package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.init.BaseSysinitBean;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.PinYin2Abbreviation;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.dao.ConnectionFactory;
import com.github.niupengyu.jdbc.dao.JdbcDao;
import com.github.niupengyu.jdbc.dao.JdbcUtil;
import com.github.niupengyu.jdbc.util.ColumnUtil;
import com.github.niupengyu.jdbc.util.DataSourceFactory;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.common.*;
import com.github.niupengyu.schedule.common2.face.reader.base.Compare;
import com.github.niupengyu.schedule.common2.face.reader.base.DataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.AllCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.AllTimeCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.PageCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.compare.PageTimeCompareDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.AllDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.AllTimeDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.PageDataReader;
import com.github.niupengyu.schedule.common2.face.reader.impl.PageTimeDataReader;
import com.github.niupengyu.schedule.common2.factory.LocalContext;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.factory.TaskFlowFactory;
import com.github.niupengyu.schedule.common2.factory.db.DBMetadata;
import com.github.niupengyu.schedule.common2.factory.dialect.DateFormat;
import com.github.niupengyu.schedule.common2.factory.dialect.GenSqlDialect;
import com.github.niupengyu.schedule.common2.factory.dialect.TargetGenSqlDialect;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.util.TableSql;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import oracle.sql.TIMESTAMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.io.File;
import java.sql.*;
import java.util.*;

@Service("mapperService")
public class MapperService {

    private static final Logger logger= LoggerFactory.getLogger(MapperService.class);

    @Resource(name = "connectionFactory")
    private ConnectionFactory connectionFactory;

    @Autowired
    private TableMapperDao tableMapperDao;

    @Resource(name = "mainService")
    private MainService mainService;

    @Resource(name = "taskInfoService")
    private TaskInfoService taskInfoService;


    public List<String> tables(CreateInfo createInfo) throws Exception {
        DBMetadata sql= SqlFactory.getType(createInfo,taskInfoService);
        //String selectTables=sql.selectTables();
        return sql.tables(createInfo);

    }

    public List<String> views(CreateInfo createInfo) throws Exception {
        DBMetadata sql= SqlFactory.getType(createInfo,taskInfoService);
        //String selectTables=sql.selectViews();
        return sql.views(createInfo);
    }

    /*private List<String> tablesViews(CreateInfo createInfo, String selectTables,DBMetadata sql) throws SysException {
        return sql.views(createInfo.getOwner());
    }*/

    public Map<String,Object> pk(CreateInfo createInfo,String tableName) throws Exception {
        DBMetadata sql= SqlFactory.getType(createInfo,taskInfoService);
        return sql.pk(tableName);

    }

    public List<Map<String,Object>> columns(CreateInfo createInfo,String tableName) throws Exception {

        DBMetadata sql=SqlFactory.getType(createInfo,taskInfoService);
        //String selectTables=sql.selectColumns();
        return sql.tableColumns(createInfo.getOwner(),tableName);

    }



    public StringBuilder createTable(CreateInfo createInfo,String part) throws Exception {
        String[] tableNames=createInfo.getTableNames();
        StringBuilder stringBuilder=new StringBuilder();
        for(String tableName:tableNames){
            List<Map<String,Object>> list=columns(createInfo,tableName);
            StringBuilder sb=new StringBuilder();
            sb.append("CREATE TABLE ").append(tableName).append(" ( \n");
            int length=list.size();
            int i=0;
            for(Map<String,Object> map:list){
                String columnName=StringUtil.valueOf(map.get("COLUMN_NAME"));
                String comments=StringUtil.valueOf(map.get("COMMENTS"));
                String type=StringUtil.valueOf(map.get("DATA_TYPE")).toUpperCase();
                String typeStr=" String DEFAULT '' COMMENT '";
                if(type.indexOf("NUMBER")>-1){
                    String scale=StringUtil.valueOf(map.get("DATA_SCALE"));
                    if(!"".equals(scale)){
                        int f=Integer.parseInt(scale);
                        if(f>0){
                            typeStr=" Float32 DEFAULT 0.0 COMMENT '";
                        }else{
                            typeStr=" Int32 DEFAULT 0 COMMENT '";
                        }
                    }
                }
                if(type.indexOf("TIMESTAMP")>-1||type.indexOf("DATE")>-1){
                    typeStr=" DateTime DEFAULT now() COMMENT '";
                }
                sb.append(columnName).
                        append(typeStr)
                        .append(comments)
                        .append("'");
                i++;
                if(i<length){
                    sb.append(",\n ");
                }
            }
            Map<String,Object> pk=pk(createInfo,tableName);
            sb.append("\n )  ENGINE = ReplacingMergeTree() PARTITION BY "+part+" ")
                    .append(" ORDER BY ")
                    .append(StringUtil.valueOf(pk.get("COLUMN_NAME"),"$ID"))
                    .append(" SETTINGS index_granularity = 8192");
            stringBuilder.append(sb.toString()).append("\n");
            stringBuilder.append("\n");
        }
        return stringBuilder;
    }

    public List<Map<String,Object>> exeSql(CreateInfo createInfo,String sqlselect,
                                           String sqlfrom,String sqlwhere) throws Exception {
        DBMetadata sql1=SqlFactory.getType(createInfo,taskInfoService);
        return sql1.sqlColumn(sqlselect,sqlfrom,sqlwhere);
    }




    public void genCode(CodeInfo createInfo, List<Column> columns) throws Exception {
        //String db=createInfo.getDb();
        DBMetadata sql=SqlFactory.getType(createInfo,taskInfoService);
        CreateInfo target=createInfo.getTarget();
        DBMetadata targetSql=SqlFactory.getType(target,taskInfoService);
        DbInfo dbInfo=sql.getDbInfo();
        //String dbName=PinYin2Abbreviation.cn2py1(dbInfo.getDbName());
        //checkDbName(dbName);
        DbInfo targetDbInfo=targetSql.getDbInfo();
        //String targetDbName=PinYin2Abbreviation.cn2py1(targetDbInfo.getDbName());
        //checkDbName(targetDbName);
        /*if(StringUtil.isNull(db)){
            dbInfo.setId(IdGeneratorUtil.uuid32());
            dbInfo.setState(1);
            dbInfo.setDbAlias(dbName);
            createInfo.setDb(dbInfo.getId());
            dbInfo.setType(createInfo.getDbType());
            this.tableMapperDao.saveDb(dbInfo);
        }

        if(StringUtil.isNull(target.getDb())){
            targetDbInfo.setId(IdGeneratorUtil.uuid32());
            targetDbInfo.setState(1);
            targetDbInfo.setDbAlias(targetDbName);
            targetDbInfo.setType(target.getDbType());
            target.setDb(targetDbInfo.getId());
            this.tableMapperDao.saveDb(targetDbInfo);
        }*/
        Table table=new Table(target,createInfo);

        checkTableName(table.getName());


        //String dbId=dbInfo.getId();
        //String targetDBiD=targetDbInfo.getId();

        /*if(StringUtil.notNull(createInfo.getOwner())){
            dbInfo.setOwner(createInfo.getOwner());
        }*/
        GenSqlDialect genSql=SqlFactory.gen(createInfo,dbInfo,columns);

        /*if(StringUtil.notNull(createInfo.getTargetOwner())){
            targetDbInfo.setOwner(createInfo.getTargetOwner());
        }*/
        TargetGenSqlDialect targetGenSql=SqlFactory.targetGen(createInfo,targetDbInfo,columns);

        String count=genSql.total();
        String pagec=null;
        String listc=null;
        String countc=null;
        if(table.isComparesj()){
            pagec=genSql.compareList();
            countc=genSql.compareTotal();
            listc=genSql.compareList();
        }
        String page=genSql.list();
        String list=genSql.list();

        String one=genSql.one();
        String max=genSql.max();

        String has=targetGenSql.has();
        String update=targetGenSql.update();
        String delete=targetGenSql.delete();
        String insert=targetGenSql.insert();
        String total=targetGenSql.total();
        String deletes=targetGenSql.deleteIn();
        String allList=targetGenSql.allList();
        Connection conn=null;
        PreparedStatement tableStmt=null;
        PreparedStatement sqlStmt=null;
        PreparedStatement columnStmt=null;
        try {
            conn=connectionFactory.createConn("scheduleDB");
            conn.setAutoCommit(false);
            tableStmt=conn.prepareStatement(TableSql.insertTable);
            sqlStmt=conn.prepareStatement(TableSql.insertSql);
            columnStmt=conn.prepareStatement(TableSql.insertColumn);
            tableStmt.setString(1,table.getId());
            tableStmt.setString(2,table.getTargetDb());
            tableStmt.setString(3,table.getDb());
            tableStmt.setString(4,table.getTn());
            tableStmt.setString(5,table.getModel());
            tableStmt.setBoolean(6,table.isPage());
            tableStmt.setBoolean(7,table.isBatch());
            tableStmt.setBoolean(8,table.isGxsjc());
            tableStmt.setBoolean(9,table.isComparesj());
            tableStmt.setString(10,table.getComparesjValue());
            tableStmt.setString(11,table.getTtn());
            tableStmt.setString(12,genSql.getBaseSql());
            tableStmt.setString(13,table.getName());
            tableStmt.setInt(14,1);
            tableStmt.setString(15,createInfo.getExemodel());
            tableStmt.setString(16,table.getPk());
            tableStmt.setString(17,table.getTargetpk());
            tableStmt.setBoolean(18,table.isMin());
            tableStmt.setString(19,table.getMinsj());
            tableStmt.setBoolean(20,table.isPkReplace());
            tableStmt.setString(21,target.getDbType());
            tableStmt.setString(22,createInfo.getDbType());
            tableStmt.setString(23,createInfo.getGxsjcValue());
            tableStmt.setString(24,createInfo.getTargetComparesjValue());
            tableStmt.setString(25,createInfo.getSyncMode());
            tableStmt.setBoolean(26,createInfo.getTimeOrder());
            tableStmt.setString(27,createInfo.getTarget().getOwner());
            tableStmt.setString(28,createInfo.getOwner());
            tableStmt.execute();

            sqlStmt.setString(1,IdGeneratorUtil.uuid32());
            sqlStmt.setString(2,table.getId());
            sqlStmt.setString(3,count);
            sqlStmt.setString(4,page);
            sqlStmt.setString(5,countc);
            sqlStmt.setString(6,pagec);
            sqlStmt.setString(7,one);
            sqlStmt.setString(8,max);
            sqlStmt.setString(9,has);
            sqlStmt.setString(10,update);
            sqlStmt.setString(11,delete);
            sqlStmt.setString(12,insert);
            sqlStmt.setString(13,total);
            sqlStmt.setString(14,deletes);
            sqlStmt.setString(15,createInfo.getMinsj());
            sqlStmt.setString(16,list);
            sqlStmt.setString(17,listc);
            sqlStmt.setString(18,allList);
            sqlStmt.execute();
            int i=1;
            for(Column column:columns){
                columnStmt.setString(1,IdGeneratorUtil.uuid32());
                columnStmt.setString(2,table.getId());
                columnStmt.setString(3,column.getName1());
                columnStmt.setString(4,column.getDataType());
                columnStmt.setString(5,column.getKey1());
                columnStmt.setString(6,column.getDefaultValue());
                columnStmt.setBoolean(7,column.isPk());
                columnStmt.setInt(8,column.getState());
                columnStmt.setInt(9,i);
                columnStmt.setBoolean(10,column.isUpdate1());
                columnStmt.setBoolean(11,column.isSelect1());
                columnStmt.setBoolean(12,column.isGxsjc());
                columnStmt.setBoolean(13,column.isCompare());
                columnStmt.setBoolean(14,column.isConvertData());
                columnStmt.setString(15,column.getSourceType());
                columnStmt.setString(16,column.getFormat());
                i++;
                columnStmt.addBatch();
            }
            columnStmt.executeBatch();
            conn.commit();
        } catch (Exception e) {
            JdbcDao.rollback(conn);
            e.printStackTrace();
            throw new SysException(e.getMessage());
        }finally {
            JdbcDao.closeStmt(tableStmt,sqlStmt,columnStmt);
            JdbcDao.closeConn(conn);
            tableStmt=null;
            sqlStmt=null;
            columnStmt=null;
            conn=null;
        }
        //insertTable;
        //insertSql;
        //insertColumns;

    }

    private void checkTableName(String name) throws SysException {
        Map map=this.tableMapperDao.tableName(name);
        if(StringUtil.mapNotNull(map)){
            throw new SysException("数据库名称已存在 ["+name+"]");
        }
    }



    /*private void checkDbName(String targetDbName) throws SysException {
        DbInfo dbInfo=this.tableMapperDao.selectDbAlias(targetDbName);
        if(dbInfo!=null){
            throw new SysException("数据库名称已存在 ["+targetDbName+"]");
        }
    }*/

    public Table tableinfo(String id) {
        return this.tableMapperDao.tableInfo(id);
    }

    public List<Column> columnList(String id) {
        return this.tableMapperDao.column(id);
    }

    public List<Column> columnList(Table table) throws Exception {
        String id=table.getId();
        List<Column> columns=this.tableMapperDao.column(id);
        Map<String,Column> columnMap=new HashMap<>();
        for(Column column:columns){
            String name=column.getName1();
            columnMap.put(name,column);
        }
        String model=table.getSyncMode();
        DBMetadata dbMetadata=SqlFactory.getType(table,taskInfoService);
        List<Map<String,Object>> list;
        if("sql".equals(model)){
            //List<Map<String,Object>> list=this.exeSql();
            JSONObject selectBean=JSONObject.parseObject(table.getTableSql());
            list=dbMetadata.sqlColumn(selectBean.getString("select"),selectBean.getString("from")
                    ,selectBean.getString("where"));
        }else{
            //String selectTables=dbMetadata.selectColumns();
            list=dbMetadata.tableColumns(table.getOwner(),table.getTn());
        }
        for(Map<String,Object> map:list){
            String columnName=StringUtil.valueOf(map.get("COLUMN_NAME"));
            String dataType=StringUtil.valueOf(map.get("DATA_TYPE"));
            String dataLength=StringUtil.valueOf(map.get("DATA_LENGTH"));
            String commons=StringUtil.valueOf(map.get("COMMENTS"));
            if(columnMap.containsKey(columnName)){
                Column column=columnMap.get(columnName);
                column.setSourceDataType(dataType);
            }else{
                Column column=new Column();
                column.setId(IdGeneratorUtil.uuid32());
                column.setName1(columnName);
                column.setKey1(columnName);
                column.setSourceDataType(dataType);
                column.setDataLength(dataLength);
                column.setCommon(commons);
                column.setChecked(false);
                column.setDefaultValue("<无>");
                columns.add(column);
            }
        }
        return columns;
    }

    public Sql sqlInfo(String id) {
        return this.tableMapperDao.sql(id);
    }


    /*public void initConnectionHolder(String id) throws Exception {
        Table table=tableMapperDao.tableInfo(id);
        DbInfo dbInfo=this.selectDbInfo(table.getDb());
        List<Column> columns=this.tableMapperDao.column(id);
        DbInfo targetDbInfo=this.selectDbInfo(table.getTargetDb());
        //DBMetadata dbMetadata=SqlFactory.getType(dbInfo);
        DateFormat dateFormat=SqlFactory.dialect(table);
        ConnectionHolder.setConn(table,dateFormat,columns,dbInfo,targetDbInfo);

    }*/

    public void initConnectionHolder(String dbId,String targetDbId) throws Exception {
        DbInfo dbInfo=this.selectDbInfo(dbId);
        DbInfo targetDbInfo=this.selectDbInfo(targetDbId);
        LocalContext.setJdbcDao(dbInfo,targetDbInfo);
    }

    /*public void initConnectionHolder(String[] dbId) throws Exception {
        List<DbInfo> list=this.tableMapperDao.selectDbInfos(dbId);
        ConnectionHolder.setConn(list);
    }*/

    /*public void initConnectionName(String name) throws Exception {
        TaskTimer taskTimer=this.mainService.getTimer(name);
        String id=taskTimer.getTableId();
        Table table=tableMapperDao.tableInfo(id);
        DbInfo dbInfo=this.selectDbInfo(table.getDb());
        List<Column> columns=this.tableMapperDao.column(id);
        DbInfo targetDbInfo=this.selectDbInfo(table.getTarget_db());
        //DBMetadata dbMetadata=SqlFactory.getType(dbInfo);
        //Connection conn=SqlFactory.getConnection(dbInfo);
        //Connection targetConn=SqlFactory.getConnection(targetDbInfo);

        dbInfo.setType(table.getDbComponent());
        DateFormat dateFormat=SqlFactory.dialect(table);
        ConnectionHolder.setConn(table,dateFormat,columns*//*,conn,targetConn*//*);
    }*/

    public DbInfo selectDbInfo(String id) {
        DbInfo dbInfo=this.tableMapperDao.selectDbInfo(id);
        //dbInfo.setParam();
        return dbInfo;
    }

    public DbInfo selectDbInfoName(String name) {
        DbInfo dbInfo=this.tableMapperDao.selectDbInfoName(name);
        return dbInfo;
    }

    public void initdb() {
        logger.info("初始化数据库类型");
        List<JSONObject> db=this.mainService.supportDb();
        SqlFactory.initDb(db);
        logger.info("初始化方言");
        List<JSONObject> dialect=this.mainService.supportDialect("source");
        List<JSONObject> targetDialect=this.mainService.supportDialect("target");
        SqlFactory.initDialect(dialect);
        SqlFactory.initTargetDialect(targetDialect);
        /*logger.info("初始化字段类型");
        List<JSONObject> columnType=this.tableMapperDao.columnTypes();
        SqlFactory.initColumnType(columnType);*/
        logger.info("完成初始化");
    }

    public void genCodes(CodeInfo codeInfo) throws Exception{
        String[] targetPks=codeInfo.getTargetpk().split(",");
        List<String> set= Arrays.asList(targetPks);
        for(String table:codeInfo.getTableNames()){
            List<Map<String,Object>> columnList=this.columns(codeInfo,table);
            List<Column> columns=new ArrayList<>();
            for(Map<String,Object> map:columnList){
                //String columnName=StringUtil.valueOf(map.get("COLUMN_NAME"));
                String key=StringUtil.valueOf(map.get("COLUMN_NAME"));
                String defaultValue="<无>";
                String defaultType=setType(map);
                Column column=new Column();
                column.setName1(key);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf(defaultValue));
                column.setDataType(defaultType);
                if(set.contains(column.getKey1())){
                    column.setUpdate1(false);
                    column.setPk(true);
                }else{
                    column.setUpdate1(true);
                    column.setPk(false);
                }
                column.setState(1);
                column.setCompare(codeInfo.isComparesj()&&key.equals(codeInfo.getComparesjValue()));
                column.setGxsjc(codeInfo.isGxsjc()&&key.equals(codeInfo.getGxsjcValue()));
                columns.add(column);
            }
            boolean rksj=codeInfo.isRksj();
            if(rksj){
                Column insert=new Column();
                insert.setPk(false);
                insert.setDataType("Timestamp");
                insert.setName1(codeInfo.getInsertTime());
                insert.setKey1(codeInfo.getInsertTime());
                insert.setUpdate1(false);
                insert.setDefaultValue("now");
                insert.setSelect1(false);
                insert.setState(1);

                Column update=new Column();
                update.setPk(false);
                update.setDataType("Timestamp");
                update.setKey1(codeInfo.getUpdateTime());
                update.setName1(codeInfo.getUpdateTime());
                update.setUpdate1(true);
                update.setDefaultValue("now");
                update.setSelect1(false);
                update.setState(1);
                columns.add(insert);
                columns.add(update);
            }
            codeInfo.setTargetTable(table);
            codeInfo.setSyncName(table);
            codeInfo.setTableName(table);
            this.genCode(codeInfo,columns);
        }

    }

    private String setType(Map<String, Object> map) {
        String type=StringUtil.valueOf(map.get("DATA_TYPE")).toUpperCase();
        String typeStr="String";
        if(type.indexOf("NUMBER")>-1){
            String scale=StringUtil.valueOf(map.get("DATA_SCALE"));
            if(!"".equals(scale)){
                int f=Integer.parseInt(scale);
                if(f>0){
                    typeStr="Double";
                }else{
                    typeStr="Int";
                }
            }
        }
        if(type.indexOf("TIMESTAMP")>-1||type.indexOf("DATE")>-1){
            typeStr="Timestamp";
        }
        return typeStr;
    }

    public void deleteTable(String[] ids) {
        for(String id:ids){
            this.tableMapperDao.deleteTable(id);
            this.tableMapperDao.deleteColumns(id);
            this.tableMapperDao.deleteSql(id);
        }
    }

    public void updateTable(Table table) throws Exception {
        /*JdbcUtil jdbcUtil=null;
        String id=table.getId();
        try{
            jdbcUtil=new JdbcUtil(connectionFactory.createConn("scheduleDB"));
            String pk=table.getPk();
            String tpk=table.getTargetpk();
            String tableUpdateSql="update guiyjz_schedule_table set table_pk=?,table_tpk=? where table_id=?";
            jdbcUtil.executeUpdate(tableUpdateSql,new Object[]{pk,tpk,id});
            String[] pks=pk.split(",");
            String[] tpks=tpk.split(",");
            String updateColumn="update guiyjz_schedule_table_column set column_pk=0 where table_id=?";
            jdbcUtil.executeUpdate(updateColumn,new Object[]{id});
            for(String p:pks){
                String updatePk="update guiyjz_schedule_table_column set column_pk=1 where table_id=? and table_pk=?";
                jdbcUtil.executeUpdate(updatePk,new Object[]{id,p});
            }

            jdbcUtil.commit();
        }catch (Exception e){
            e.printStackTrace();
            throw new SysException(e.getMessage());
        }finally {
            if(jdbcUtil!=null){
                jdbcUtil.close();
            }
        }
        List<Column> columns=tableMapperDao.column(id);
        Sql sql=createSql(table,columns);
        this.tableMapperDao.updateSql(sql);*/
    }

    private Sql createSql(Table table,List<Column> columns) throws Exception {
        DbInfo dbInfo=this.tableMapperDao.selectDbInfo(table.getDb());
        DbInfo targetDbInfo=this.tableMapperDao.selectDbInfo(table.getTargetDb());
        GenSqlDialect genSql=SqlFactory.gen(table,dbInfo);
        TargetGenSqlDialect targetGenSql=SqlFactory.targetGen(table,targetDbInfo,columns);
        String count=genSql.total();
        String pagec=null;
        String listc=null;
        String countc=null;

        String page=genSql.list();
        String list=genSql.list();

        String one=genSql.one();
        String max=genSql.max();

        String has=targetGenSql.has();
        String update=targetGenSql.update();
        String delete=targetGenSql.delete();
        String insert=targetGenSql.insert();
        String total=targetGenSql.total();
        String deletes=targetGenSql.deleteIn();
        String allList=targetGenSql.allList();
        Sql sql=new Sql();
        sql.setId(IdGeneratorUtil.uuid32());
        sql.setTotalSql(count);

        sql.setPageListSql(page);
        sql.setListSql(list);
        sql.setSelectOneSql(one);
        sql.setMaxSql(max);
        sql.setHasOneSql(has);
        sql.setUpdateSql(update);
        sql.setDeleteSql(delete);
        sql.setInsertSql(insert);
        sql.setUpdateSql(update);
        sql.setDeleteInSql(deletes);

        sql.setTable1(table.getId());
        if(table.isComparesj()){
            pagec=genSql.compareList();
            countc=genSql.compareTotal();
            listc=genSql.compareList();

            sql.setComparePageListSql(pagec);
            sql.setCompareListSql(listc);
            sql.setCompareTotalSql(countc);

            sql.setTargetCompareTotalSql(total);

        }
        sql.setTargetCompareAllListSql(allList);
        return sql;
    }


    public void updateColumn(String id, List<Column> list, String pkColumn,String targetPkColumn,
                             String compareColumn,boolean compare,
                             String targetCompareColumn, boolean gxsjc,String gxsjcColumn,boolean pkReplace,
                             boolean page) throws SysException {
        if(StringUtil.isNull(pkColumn)){
            throw new SysException("主键没有设置");
        }
        JdbcUtil jdbcUtil=null;
        try{
            String pk=pkColumn.substring(1);
            String tpk=targetPkColumn.substring(1);
            jdbcUtil=new JdbcUtil();
            jdbcUtil.setConnection(connectionFactory.createConn("scheduleDB"));
            String updateTable="update guiyjz_schedule_table set table_pk=?,table_tpk=?," +
                    "table_isgxsjc=?,table_iscomparesj=?,table_comparesj=?,table_target_comparesj=?,table_gxsjc=?," +
                    "table_pk_replace=?,table_ispage=? " +
                    "where table_id=?";
            jdbcUtil.executeUpdate(updateTable,new Object[]{pk,tpk,gxsjc,compare,compareColumn,
                    targetCompareColumn,gxsjcColumn,pkReplace,page,id});
            String deleteColumns="delete from guiyjz_schedule_table_column where column_table=?";
            jdbcUtil.executeUpdate(deleteColumns,new Object[]{id});
            /*String insert="insert into guiyjz_schedule_table_column(column_id,column_table,column_name,column_data_type," +
                    "column_key,column_default_value,column_pk,column_state,column_index,column_update,column_select," +
                    "column_gxsjc,column_compare,column_convert,column_source,column_format) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";*/
            List<Object[]> objectList=new ArrayList<>();
            for(Column column:list){
                Object[] objects=new Object[]{column.getId(),id,column.getName1(),column.getDataType(),
                        column.getKey1(),column.getDefaultValue(),column.isPk(),column.getState(),column.getIndex1(),column.isUpdate1(),
                        column.isSelect1(),column.isGxsjc(),column.isCompare(),
                        column.isConvertData(),column.getSourceType(),column.getFormat()};
                objectList.add(objects);
            }
            jdbcUtil.executeBatch(TableSql.insertColumn,objectList);
            Table table=this.tableMapperDao.tableInfo(id);
            table.setComparesj(compare);
            table.setPk(pk);
            table.setTargetpk(tpk);
            table.setComparesjValue(compareColumn);
            table.setTargetComparesjValue(targetCompareColumn);
            table.setGxsjc(gxsjc);
            table.setGxsjcValue(gxsjcColumn);
            table.setPkReplace(pkReplace);
            table.setPage(page);
            Sql sql=createSql(table,list);
            String insertSql="update guiyjz_schedule_table_sql set sql_count=?,sql_page=?," +
                    "sql_countc=?,sql_pagec=?,sql_one=?,sql_max=?,sql_g_has=?,sql_g_update=?,sql_g_delete=?,sql_g_insert=?," +
                    "sql_g_totalc=?,sql_g_deletes=?,sql_listc=?,sql_list=?,sql_minsj=?,sql_all_list=? where sql_table=? ";
            jdbcUtil.executeUpdate(insertSql,new Object[]{sql.getTotalSql(),sql.getPageListSql(),
            sql.getCompareTotalSql(),sql.getComparePageListSql(),sql.getSelectOneSql(),sql.getMaxSql(),sql.getHasOneSql(),
            sql.getUpdateSql(),sql.getDeleteSql(),sql.getInsertSql(),sql.getTargetCompareTotalSql(),sql.getDeleteInSql(),
            sql.getCompareListSql(),sql.getListSql(),sql.getMinSql(),sql.getTargetCompareAllListSql(),id});
            jdbcUtil.commit();
        }catch (Exception e){
            if(jdbcUtil!=null){
                jdbcUtil.rollBack();
            }
            e.printStackTrace();
            throw new SysException(e.getMessage());
        }finally {
            if(jdbcUtil!=null){
                jdbcUtil.close();
            }
        }

    }

    public static void main(String[] args) {
        /*String time="0000-01-01 00:00:00";
        System.out.println(Timestamp.valueOf(0));*/
    }

    public JSONArray datatotal(String[] taskNames) throws Exception {
        JSONArray jsonArray=new JSONArray();
        for(String taskName:taskNames){
            Table table=this.tableMapperDao.tableInfo(taskName);
            DbInfo dbInfo=this.tableMapperDao.selectDbInfo(table.getDb());
            //DbInfo tdbInfo=this.tableMapperDao.selectDbInfo(table.getTargetDb());
            String pk=table.getPk();
            //String tpk=table.getTargetpk();
            String tableName=table.getTn();
            //String targetTableName=table.getTtn();
            String model=table.getSyncMode();
            Map<String,Object> d=setData(taskName,pk,tableName,model,dbInfo);
            /*
            DbInfo tdbInfo=this.tableMapperDao.selectDbInfo(table.getTargetDb());
            String tpk=table.getTargetpk();
            String targetTableName=table.getTtn();
            jsonArray.add(setData(tpk,targetTableName,model,tdbInfo));
            Map<String,Object> td=setData(tpk,targetTableName,model,tdbInfo);

            JSONObject data=new JSONObject();
            data.put("d",d);
            data.put("td",td);
            jsonArray.add(data);*/
            jsonArray.add(d);
        }
        return jsonArray;
    }

    private Map<String,Object> setData(String taskName,String pk, String tableName, String model, DbInfo dbInfo) throws Exception{
        if("sql".equals(model)||pk.split(",").length>1){
            Map<String,Object> map=new HashMap<>();
            map.put("total",-1);
            map.put("distotal",-1);
            map.put("name",taskName);
            return map;
        }
        String owner=dbInfo.getOwner();
        String sql="select count("+pk+") as total,count(distinct "+pk+") as distotal from "+
                (StringUtil.isNull(owner)?"":owner+".")+tableName;
        JdbcDao jdbcDao=new JdbcDao(SqlFactory.dataSourceConnection(dbInfo));
        Map<String,Object> map=jdbcDao.getOne(sql);
        map.put("name",taskName);
        return map;
    }

    public JSONArray datattotal(String[] taskNames) throws Exception {
        JSONArray jsonArray=new JSONArray();
        for(String taskName:taskNames){
            Table table=this.tableMapperDao.tableInfo(taskName);
            //DbInfo dbInfo=this.tableMapperDao.selectDbInfo(table.getDb());
            DbInfo tdbInfo=this.tableMapperDao.selectDbInfo(table.getTargetDb());
            //String pk=table.getPk();
            String tpk=table.getTargetpk();
            //String tableName=table.getTn();
            String targetTableName=table.getTtn();
            String model=table.getSyncMode();
            jsonArray.add(setData(taskName,tpk,targetTableName,model,tdbInfo));
        }
        return jsonArray;
    }


}
