package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.core.util.ZipCompressor;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.service.common.reader.AllReaderImpl;
import com.github.niupengyu.schedule.common2.service.common.reader.AllTimeReaderImpl;
import com.github.niupengyu.schedule.common2.service.common.reader.PageReaderImpl;
import com.github.niupengyu.schedule.common2.service.common.reader.PageTimeReaderImpl;
import com.github.niupengyu.schedule.common2.util.ModelType;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.HashMap;
import java.util.Map;

@Service("genProService")
public class GenProService {

    @Autowired
    private TableMapperDao tableMapperDao;

    public File gen(String packageName,String[] ids) throws Exception {
        long time=System.currentTimeMillis();
        String path="outFile/"+time+"/";
        for(String id:ids){
            gen(packageName,path,id);
        }
        ZipCompressor zip=new ZipCompressor();
        File file=new File(path);
        File out=new File("outFile/",time+".zip");
        zip.compressExe(file,out);
        return out;
    }

    public void gen(String packageName,String path,String id) throws Exception {
        Table table = this.tableMapperDao.tableInfo(id);
        Sql sql = this.tableMapperDao.sql(id);
        Map<String,String> map=new HashMap<>();
        Configuration cfg =null;
        cfg = new Configuration(Configuration.VERSION_2_3_28);
        ;
        cfg.setDirectoryForTemplateLoading(new File(FileUtil.getResourcesPath(GenProService.class)+"/config/temp"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template template = cfg.getTemplate("TaskDemo.ftl");
        Map<String,String> taskMap=new HashMap<>();
        String exeModel=table.getModel();
        String dataReader="";
        String dataWriter="";


        if(table.isBatch()){
            /*if(ModelType.deleteBeforeInsert.equals(exeModel)){
                dataWriter=",BatchDeleteBeforeInsertWriter";
            }else if(ModelType.saveOrUpdate.equals(exeModel)){
                dataWriter=",BatchWriter";
            }else if(ModelType.saveWriter.equals(exeModel)){
                dataWriter=",BatchInsertWriter";
            }*/
            dataWriter=","+ModelType.batchTypeMap(exeModel).getSimpleName();
        }else{
            /*if(ModelType.deleteBeforeInsert.equals(exeModel)){
                dataWriter=",DeleteBeforeInsertWriter";
            }else if(ModelType.saveOrUpdate.equals(exeModel)){
                dataWriter=",SaveOrUpdateWriter";
            }else if(ModelType.saveWriter.equals(exeModel)){
                dataWriter=",SaveWriter";
            }*/
            dataWriter=ModelType.oneTypeMap(exeModel).getSimpleName();
        }
        String compare="";
        if(table.isComparesj()){
            if(!table.isGxsjc()&&!table.isPage()){
                dataReader="AllCompareDataReader";
            }else if(!table.isGxsjc()&&table.isPage()){
                dataReader="PageCompareDataReader";
            }else if(table.isGxsjc()&&!table.isPage()){
                dataReader="AllTimeCompareDataReader";
            }else if(table.isGxsjc()&&table.isPage()){
                dataReader="PageTimeCompareDataReader";
            }else{
                throw new SysException("找不到合适的 READER ");
            }
            if(table.isBatch()){
                compare=",BatchCompareWriter";
            }else{
                compare=",CompareWriter";
            }
        }else{
            if(!table.isGxsjc()&&!table.isPage()){
                dataReader="AllDataReader";
            }else if(!table.isGxsjc()&&table.isPage()){
                dataReader="PageDataReader";
            }else if(table.isGxsjc()&&!table.isPage()){
                dataReader="AllTimeDataReader";
            }else if(table.isGxsjc()&&table.isPage()){
                dataReader="PageTimeDataReader";
            }else{
                throw new SysException("找不到合适的 READER ");
            }
        }
        String max="";
        if(table.isGxsjc()){
            max=",MaxDate";
        }
        String min="";
        if(table.isMin()){
            max=",MinDate";
        }
        String pack=packageName;
        String name=table.getName();
        String className=Character.toUpperCase(name.charAt(0)) + name.substring(1);

        taskMap.put("model",dataReader+dataWriter+compare+max+min);
        taskMap.put("exeModel",exeModel);
        taskMap.put("id",id);
        taskMap.put("compare",compare);
        taskMap.put("max",max);
        taskMap.put("pack",pack);
        taskMap.put("name",name);
        taskMap.put("className",className);
        taskMap.put("ispage",table.isPage()+"");
        taskMap.put("isbatch",table.isBatch()+"");
        taskMap.put("iscomparesj",table.isComparesj()+"");
        taskMap.put("isgxsjc",table.isGxsjc()+"");
        taskMap.put("isPkReplace",table.isPkReplace()+"");

        String sourceClass=className+"Source";
        String targetClass=className+"Target";
        taskMap.put("sourceClass",sourceClass);
        taskMap.put("targetClass",targetClass);

        taskMap.put("sourceValue",Character.toLowerCase(sourceClass.charAt(0))+sourceClass.substring(1));
        taskMap.put("targetValue",Character.toLowerCase(targetClass.charAt(0))+targetClass.substring(1));

        Template dao = cfg.getTemplate("SourceDao.ftl");

        Map<String,String> sourceMap=new HashMap<>();
        sourceMap.put("count", StringUtil.valueOf(sql.getTotalSql()));
        sourceMap.put("selectData", StringUtil.valueOf(sql.getPageListSql()));
        sourceMap.put("selectOne", StringUtil.valueOf(sql.getSelectOneSql()));
        sourceMap.put("max", StringUtil.valueOf(sql.getMaxSql()));
        sourceMap.put("selectCompareData", StringUtil.valueOf(sql.getCompareListSql()));
        sourceMap.put("compareTotal", StringUtil.valueOf(sql.getCompareTotalSql()));
        sourceMap.put("sourceClass",sourceClass);

        Template targetDao = cfg.getTemplate("TargetDao.ftl");

        Map<String,String> targetMap=new HashMap<>();
        targetMap.put("update", StringUtil.valueOf(sql.getUpdateSql()));
        targetMap.put("save", StringUtil.valueOf(sql.getInsertSql()));
        targetMap.put("compareTotal", StringUtil.valueOf(sql.getTargetCompareTotalSql()));
        targetMap.put("deletes", StringUtil.valueOf(sql.getDeleteInSql()));
        targetMap.put("delete", StringUtil.valueOf(sql.getDeleteSql()));
        targetMap.put("hasOne", StringUtil.valueOf(sql.getHasOneSql()));
        targetMap.put("targetClass",targetClass);
        path=path+name+"/";
        FileUtil.mkdirs1(path);
        outFile(path,className,taskMap,template);
        outFile(path,sourceClass,sourceMap,dao);
        outFile(path,targetClass,targetMap,targetDao);
    }


    private void outFile(String path, String className, Map<String, String> map,Template template) throws SysException {
        String file1=path+className+".java";
        File docFile = new File(file1);
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(docFile)));
            template.process(map, out);
        } catch (Exception e) {
            e.printStackTrace();
            throw new SysException("文件创建失败");
        }finally {
            FileUtil.close(out);
            out=null;
        }
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^"+file1+" 文件创建成功 !");

    }

}
