package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.schedule.mains.dao.ExceptionDao;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("exceptionService")
public class ExceptionService {

    @Autowired
    private ExceptionDao exceptionDao;


    public JSONObject list(String task,int page,int size,String type) {
        //int total=exceptionDao.total(task,type);
        int total=exceptionDao.allTotal(task,type);
        int start= PageUtil.start(page,size);
        int max=PageUtil.maxPage(size,total);
        JSONObject res=new JSONObject();
        //res.put("list",exceptionDao.list(task,type,start,size));
        res.put("list",exceptionDao.allException(task,type,start,size));
        res.put("max",max);
        res.put("id",task);
        res.put("page",page);
        res.put("type",type);
        return res;
    }

    public List<JSONObject> listJson(String task) {

        return exceptionDao.listJson(task);

    }

    public void updateState(String id, int i) {
        exceptionDao.updateState(id,i);
    }

    public void updateStates(List<JSONObject> data, int i) {
        exceptionDao.updateStates(data,i);
    }

    public JSONObject selectBean(String id) {
        return exceptionDao.selectBean(id);
    }

    public List<JSONObject> selectBeans(String[] ids) {
        return exceptionDao.selectBeans(ids);
    }
}
