package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.annotation.AutoConfig;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.schedule.distributed.client.service.ClientHandlerService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service("clientService")
@AutoConfig(name="news.client.enable")
public class DistributedClientService {

    @Resource(name = "clientHandlerService")
    private ClientHandlerService clientHandlerService;


    public void connection(String server,int port) throws SysException {
        clientHandlerService.reconnection(server,port);
    }

    public void offline() {
        clientHandlerService.offline();
    }
}
