package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.jdbc.dao.JdbcDao;
import com.github.niupengyu.jdbc.datasource.BasicDataSource;
import com.github.niupengyu.schedule.common2.bean.DataSourceInfo;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.factory.LocalContext;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.factory.db.DBMetadata;
import com.github.niupengyu.schedule.mains.dao.DataSourceDao;
import com.github.niupengyu.schedule.mains.util.ThreadPool;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("dbService")
public class DbService {

    @Resource(name = "mapperService")
    private MapperService mapperService;

    @Resource(name = "taskService")
    private TaskService taskService;

    @Autowired
    private DataSourceDao dataSourceDao;

    public JSONArray poolInfo() {
        Map<String, DataSource> map= SqlFactory.dataSourceInfo();
        JSONArray jsonArray=new JSONArray();
        for(Map.Entry<String, DataSource> entry:map.entrySet()){
            String key=entry.getKey();
            DataSource value=entry.getValue();
            DataSourceInfo obj=setDataSourceInfo(value,key);
            obj.setDb(mapperService.selectDbInfoName(key));
            jsonArray.add(obj);

        }
        return jsonArray;
    }

    private DataSourceInfo setDataSourceInfo(DataSource value,String key) {
        DataSourceInfo dataSourceInfo;
        if(value instanceof DruidDataSource){
            DruidDataSource ds=DruidDataSource.class.cast(value);
            dataSourceInfo=new DataSourceInfo(ds);
        }else if(value instanceof BasicDataSource){
            BasicDataSource ds=BasicDataSource.class.cast(value);
            dataSourceInfo=new DataSourceInfo(ds);
        }else{
            dataSourceInfo=new DataSourceInfo();
        }
        return dataSourceInfo;
    }

    public List<TaskInfo> taskinfo(String name) {
        return taskService.taskInfo(name);
    }

    public List<DbInfo> list(){
        List<DbInfo> dbInfos=dataSourceDao.list();
        for(DbInfo dbInfo:dbInfos){
            String key=dbInfo.getDbName();
            Map<String, DataSource> map= SqlFactory.dataSourceInfo();
            DataSource value=map.get(key);
            DataSourceInfo obj=setDataSourceInfo(value,key);
            dbInfo.setDataSourceInfo(obj);
        }
        return dbInfos;
    }

    public long testConnection(String id){
        DbInfo dbInfo=mapperService.selectDbInfo(id);
        return testConnection(dbInfo);
    }

    public long testConnection(DbInfo dbInfo){
        long mi=-1;
        Connection conn=null;
        long start=System.currentTimeMillis();
        try{
            conn=SqlFactory.getType(dbInfo).connection();
            if(conn!=null&&!conn.isClosed()){
                mi=System.currentTimeMillis()-start;
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            JdbcDao.closeConn(conn);
        }
        return mi;
    }

    /*public long testDataSource(String id){
        long mi=-1;
        DbInfo dbInfo=mapperService.selectDbInfo(id);
        Connection conn=null;
        long start=System.currentTimeMillis();
        try{
            conn=DBMetadata.(dbInfo);
            if(conn!=null&&!conn.isClosed()){
                mi=System.currentTimeMillis()-start;
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            JdbcDao.closeConn(conn);
        }
        return mi;
    }*/

    public List<TaskInfo> test(String name) {

        Runnable r=new Runnable() {
            @Override
            public void run() {
                try {
                    mapperService.initConnectionHolder(null,"3");
                    for(int i=0;i<1000;i++){
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable r1=new Runnable() {
            @Override
            public void run() {
                try {
                    mapperService.initConnectionHolder(null,"3");
                    for(int i=0;i<1000;i++){
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Runnable r2=new Runnable() {
            @Override
            public void run() {
                try {
                    mapperService.initConnectionHolder(null,"3");
                    for(int i=0;i<1000;i++){
                        LocalContext.getTargetJdbcDao().conn().close();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ThreadPool.pools.execute(r);
        ThreadPool.pools.execute(r2);
        ThreadPool.pools.execute(r1);

        return new ArrayList<>();
    }

    public static void main(String[] args) {
        /*Runnable r=new Runnable() {
            @Override
            public void run() {
                try {
                    ConnectionHolder.setConn(null,new DbInfo());
                    Thread.sleep(100);
                    for(int i=0;i<1000;i++){
                        ConnectionHolder.getTargetConn();
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        ThreadPool.pools.execute(r);*/
        Map<String,String> map=new HashMap<>();
        map.put("data1","1");
        map.put("data2","2");
        map.put("data3","3");
        String data=map.get("data1");
        map.clear();
        System.out.println(data);
    }

    public void startDb(String id) {
        this.dataSourceDao.updateState(id,1);
    }

    public void stopDb(String id) {
        this.dataSourceDao.updateState(id,2);
    }

    public void refresh() {
        mapperService.initdb();
        SqlFactory.clear();
    }


    public void save(DbInfo dbInfo) {
        dbInfo.setId(IdGeneratorUtil.uuid32());
        dbInfo.setState(1);
        dataSourceDao.saveDb(dbInfo);
    }

    public List dialects() {
        return this.dataSourceDao.dialects();
    }

    public List database() {

        return this.dataSourceDao.database();
    }

    public DbInfo getById(String id) {
        return this.dataSourceDao.getById(id);
    }

    public void update(DbInfo dbInfo) {
        this.dataSourceDao.updateDb(dbInfo);
    }
}
