package com.github.niupengyu.schedule.mains.dao;

import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.*;

import java.util.List;

public interface ScheduleDao {


    @Select("select schedule_id as id,schedule_app as app,schedule_package as timerpackage," +
            "schedule_name as name,schedule_tigger as tigger,schedule_type as jobType," +
            "schedule_time as time,schedule_desc as jobDesc,schedule_tigger_group as tiggerGroup,schedule_job_group as jobGroup," +
            "schedule_status as status,schedule_batch as batch," +
            "DATE_FORMAT(schedule_start,'%Y-%m-%d %T') as startTime," +
            "DATE_FORMAT(schedule_end,'%Y-%m-%d %T') as endTime," +
            "DATE_FORMAT(schedule_next,'%Y-%m-%d %T') as nextFireTime," +
            "DATE_FORMAT(schedule_previous,'%Y-%m-%d %T') as previousFireTime," +
            "schedule_before_hours as beforeHour,"+
            "schedule_binding as binding,"+
            "schedule_table as tableId,"+
            "schedule_param as param,"+
            "schedule_state as state,schedule_bean as bean,schedule_size as size from guiyjz_schedule "+
            "where schedule_id=#{id}")
    public TaskTimer getById(@Param("id") String id);

    @Select("select schedule_id as id,schedule_app as app,schedule_package as timerpackage," +
            "schedule_name as name,schedule_tigger as tigger,schedule_type as jobType," +
            "schedule_time as time,schedule_desc as jobDesc,schedule_tigger_group as tiggerGroup,schedule_job_group as jobGroup," +
            "schedule_status as status,schedule_batch as batch," +
            "DATE_FORMAT(schedule_start,'%Y-%m-%d %T') as startTime," +
            "DATE_FORMAT(schedule_end,'%Y-%m-%d %T') as endTime," +
            "DATE_FORMAT(schedule_next,'%Y-%m-%d %T') as nextFireTime," +
            "DATE_FORMAT(schedule_previous,'%Y-%m-%d %T') as previousFireTime," +
            "schedule_before_hours as beforeHour,"+
            "schedule_binding as binding,"+
            "schedule_table as tableId,"+
            "schedule_param as param,"+
            "schedule_state as state,schedule_bean as bean,schedule_size as size from guiyjz_schedule "+
            "where schedule_name=#{name}")
    public TaskTimer getByName(String name);

    @Select("<script>" +
            "select schedule_id as id,schedule_app as app,schedule_package as timerpackage," +
            "schedule_name as name,schedule_tigger as tigger,schedule_type as jobType," +
            "schedule_time as time,schedule_desc as jobDesc,schedule_tigger_group as tiggerGroup,schedule_job_group as jobGroup," +
            "schedule_status as status,schedule_batch as batch," +
            "DATE_FORMAT(schedule_start,'%Y-%m-%d %T') as startTime," +
            "DATE_FORMAT(schedule_end,'%Y-%m-%d %T') as endTime," +
            "DATE_FORMAT(schedule_next,'%Y-%m-%d %T') as nextFireTime," +
            "DATE_FORMAT(schedule_previous,'%Y-%m-%d %T') as previousFireTime," +
            "schedule_before_hours as beforeHour,"+
            "schedule_binding as binding,"+
            "schedule_table as tableId,"+
            "schedule_param as param,"+
            "schedule_open as open1,"+
            "schedule_state as state,schedule_bean as bean,schedule_size as size from guiyjz_schedule " +
            " where 1=1 " +
            "<if test=\"type!='COMPARE' and type!=''\">" +
            " and schedule_type != 'COMPARE' " +
            "</if>" +
            "<if test=\"type=='COMPARE'\">" +
            " and schedule_type = 'COMPARE' " +
            "</if>" +
            "<if test=\"app!='' and app!=null\">" +
            " and schedule_app = #{app} " +
            "</if>" +
            "<if test=\"name!='' and name!=null\">" +
            " and schedule_name = #{name} " +
            "</if>" +
            "<if test=\"bindTask!='' and bindTask!=null\">" +
            " and schedule_binding = #{bindTask} " +
            "</if>" +
            " order by app,state " +
            "<if test=\"size!=0\">" +
            " limit #{start},#{size} " +
            "</if>" +
            "</script>")
    public List<TaskTimer> list(@Param("type") String type,@Param("name") String name,
                                @Param("app") String app,
                                @Param("bindTask") String bindTask,
                                @Param("start") int start,@Param("size") int size);


    @Update("update guiyjz_schedule set schedule_start=#{date} where schedule_name=#{name}")
    void updateTime(@Param("name") String name, @Param("date") String date);


    @Select("select schedule_name as key1,schedule_id as value1," +
            "schedule_desc as desc1,schedule_state as state,schedule_table as tableId " +
            "from guiyjz_schedule where schedule_type=#{type}")
    List<JSONObject> timer(String type);

    @Update("update guiyjz_schedule set schedule_binding=#{id} where schedule_name=#{name}")
    void updateBinding(@Param("name") String name, @Param("id") String id);

    @Update("update guiyjz_schedule set schedule_open=#{open} where schedule_name=#{name}")
    void updateOpen(@Param("open") boolean open, @Param("name") String name);


    @Select("select schedule_id as id,schedule_app as app,schedule_package as timerpackage," +
            "schedule_name as name,schedule_tigger as tigger,schedule_type as jobType," +
            "schedule_time as time,schedule_desc as jobDesc,schedule_tigger_group as tiggerGroup,schedule_job_group as jobGroup," +
            "schedule_status as status,schedule_batch as batch," +
            "DATE_FORMAT(schedule_start,'%Y-%m-%d %T') as startTime," +
            "DATE_FORMAT(schedule_end,'%Y-%m-%d %T') as endTime," +
            "DATE_FORMAT(schedule_next,'%Y-%m-%d %T') as nextFireTime," +
            "DATE_FORMAT(schedule_previous,'%Y-%m-%d %T') as previousFireTime," +
            "schedule_before_hours as beforeHour,"+
            "schedule_binding as binding,"+
            "schedule_table as tableId,"+
            "schedule_param as param,"+
            "schedule_state as state,schedule_bean as bean,schedule_size as size from guiyjz_schedule "+
            "where schedule_binding=#{id}")
    List<TaskTimer> bindingList(@Param("id") String id);

    @Select("select schedule_id as id,schedule_app as app,schedule_package as timerpackage," +
            "schedule_name as name,schedule_tigger as tigger,schedule_type as jobType," +
            "schedule_time as time,schedule_desc as jobDesc,schedule_tigger_group as tiggerGroup,schedule_job_group as jobGroup," +
            "schedule_status as status,schedule_batch as batch," +
            "DATE_FORMAT(schedule_start,'%Y-%m-%d %T') as startTime," +
            "DATE_FORMAT(schedule_end,'%Y-%m-%d %T') as endTime," +
            "DATE_FORMAT(schedule_next,'%Y-%m-%d %T') as nextFireTime," +
            "DATE_FORMAT(schedule_previous,'%Y-%m-%d %T') as previousFireTime," +
            "schedule_before_hours as beforeHour,"+
            "schedule_binding as binding,"+
            "schedule_table as tableId,"+
            "schedule_param as param,"+
            "schedule_state as state,schedule_bean as bean,schedule_size as size from guiyjz_schedule "+
            "where schedule_binding=#{id} and schedule_open=#{start}")
    List<TaskTimer> bindingStartList(@Param("id") String id,@Param("start") boolean start);

    @Insert("insert into guiyjz_schedule(schedule_id," +
            "schedule_app," +
            "schedule_name," +
            "schedule_bean," +
            "schedule_size," +
            "schedule_time," +
            "schedule_tigger," +
            "schedule_type," +
            "schedule_desc," +
            "schedule_tigger_group," +
            "schedule_job_group," +
            "schedule_status," +
            "schedule_state," +
            "schedule_before_hours," +
            "schedule_batch,schedule_table,schedule_start) values(#{id},#{app},#{name},#{bean},#{size},#{time}," +
            "#{tigger},#{jobType},#{jobDesc},#{tiggerGroup},#{jobGroup},'0','NONE',#{beforeHour},#{batch},#{tableId},#{startTime})")
    void saveTaskTimer(TaskTimer taskTimer);

    @Select("select * from guiyjz_scheudle_db_support where support_state <> 0")
    List<JSONObject> supportDb();

    @Select("<script>" +
            "select * from guiyjz_scheudle_db_dialect where dialect_state &lt;&gt; 0 " +
            "<if test=\"name!='' and name!=null\">" +
            " and dialect_type=#{name}" +
            "</if>" +
            "</script>")
    List<JSONObject> supportDialect(@Param("name") String name);

    @Select("select distinct schedule_app from guiyjz_schedule")
    List<String> getApps();

    @Select("<script>" +
            "select count(*) from guiyjz_schedule " +
            " where 1=1 " +
            "<if test=\"type!='COMPARE' and type!=''\">" +
            " and schedule_type != 'COMPARE' " +
            "</if>" +
            "<if test=\"type=='COMPARE'\">" +
            " and schedule_type = 'COMPARE' " +
            "</if>" +
            "<if test=\"app!='' and app!=null\">" +
            " and schedule_app = #{app} " +
            "</if>" +
            "<if test=\"name!='' and name!=null\">" +
            " and schedule_name = #{name} " +
            "</if>" +
            "<if test=\"bindTask!='' and bindTask!=null\">" +
            " and schedule_binding = #{bindTask} " +
            "</if>" +
            "</script>")
    int total(@Param("type") String type,@Param("name") String name,
              @Param("app") String app,
              @Param("bindTask") String bindTask);

    @Update("<script>" +
            "update guiyjz_schedule " +
            "set " +
            "schedule_app=#{app}," +
            "schedule_name=#{name}," +
            "<if test=\"bean!=null and bean!=''\">" +
            "schedule_bean=#{bean}," +
            "</if>" +
            "schedule_size=#{size}," +
            "schedule_time=#{time}," +
            "schedule_tigger=#{tigger}," +
            "schedule_type=#{jobType}," +
            "schedule_desc=#{jobDesc}," +
            "schedule_tigger_group=#{tiggerGroup}," +
            "schedule_job_group=#{jobGroup}," +
            "schedule_state=#{state}," +
            "schedule_before_hours=#{beforeHour}," +
            "schedule_batch=#{batch}," +
            "schedule_table=#{tableId}," +
            "schedule_start=#{startTime}," +
            "schedule_param=#{param} where schedule_id=#{id} " +
            "</script>")
    void updateTimer(TaskTimer taskTimer);
}
