package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.Hello;
import com.github.niupengyu.core.util.HostUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.bean.DataSourceBean;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.ExceptionService;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.schedule.mains.service.PlanService;
import com.github.niupengyu.web.content.ContentController;
import com.alibaba.fastjson.JSONObject;
import org.elasticsearch.action.search.SearchTask;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Controller
@RequestMapping("page")
public class PageController extends ContentController{

    @Resource(name = "taskInfoService")
    private TaskInfoService taskInfoService;

    @Resource(name = "exceptionService")
    private ExceptionService exceptionService;

    @Resource(name="planService")
    private PlanService planService;

    @Resource(name="mainService")
    private MainService mainService;

    @Resource(name = "mapperService")
    private MapperService mapperService;


    @RequestMapping("top")
    public String top(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", request.getLocalAddr());
        return "templates/main/top";
    }

    @RequestMapping("left")
    public String left(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", request.getLocalAddr());
        return "templates/main/left";
    }

    @RequestMapping("main")
    public String main() throws Exception {
        setRequest(request(),"NOT-COMPARE");
        return "templates/main/main";
    }

    @RequestMapping("index")
    public String index(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", request.getLocalAddr());
        return "templates/main/index";
    }


    @RequestMapping("schedule_list")
    public String schedule_list() throws Exception {
        setRequest(request(),"NOT-COMPARE");
        return "templates/main/schedule_list";
    }

    @RequestMapping("compare")
    public String compare() throws Exception {
        setRequest(request(),"COMPARE");
        return "templates/main/main";
    }

    private void setRequest(HttpServletRequest request,String type){
        request.setAttribute("typeList",mainService.getApps());
        request.setAttribute("modelList",type);
        request.setAttribute("serverId", ServiceUtil.serialNumber());
    }


    @RequestMapping("index1")
    public String index1(HttpServletRequest request) throws Exception {
        return "templates/main/index1";
    }

    @RequestMapping("home")
    public String home(HttpServletRequest request) throws Exception {
        return "templates/main/home";
    }



    @RequestMapping("datacreate")
    public String dataCreate(HttpServletRequest request) throws Exception {
        List  map=this.mainService.getDbs();
        request.setAttribute("db",map);
        return "templates/main/datacreate";
    }



    @RequestMapping("plan")
    public String plan(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", HostUtil.ipAddr());
        request.setAttribute("plans",planService.selectList());
        request.setAttribute("timers",mainService.getTimerList("","","","",0,0));
        return "templates/plan";
    }

    @RequestMapping("one")
    public String one(HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", HostUtil.ipAddr());
        request.setAttribute("timers",mainService.timer());
        return "templates/one";
    }

    @RequestMapping("history")
    public String history(String name,String time,HttpServletRequest request) throws Exception {
        request.setAttribute("hello", Hello.word());
        request.setAttribute("host", HostUtil.ipAddr());
        if(StringUtil.isNull(time)){
            time=DateUtil.dateFormatDate();
        }
        List<TaskInfo> taskInfos=  taskInfoService.dayList(name, time);
        request.setAttribute("taskInfos",taskInfos);
        request.setAttribute("time",time);
        request.setAttribute("name",name);
        return "templates/history";
    }

    @RequestMapping("nowtask")
    public String nowtask(String app,String name,HttpServletRequest request) throws Exception {
        List<TaskInfo> taskInfos=  taskInfoService.dayNowList("",name);
        request.setAttribute("taskInfos",taskInfos);
        request.setAttribute("time",DateUtil.dateFormatDate());
        request.setAttribute("name",name);
        return "templates/history";
    }

    @RequestMapping("allnowtask")
    public String allnowtask(String bingTask,String app,String name,String timeFrame,String taskstate,String tasktype,String time,HttpServletRequest request) throws Exception {
        /*List<TaskInfo> taskInfos=  taskInfoService.allNowList(app,name,timeFrame,taskstate,tasktype,time);
        request.setAttribute("taskInfos",taskInfos);
        request.setAttribute("time",StringUtil.isNull(time)?DateUtil.dateFormatDate():time);
        request.setAttribute("name",name);
        request.setAttribute("timers",this.mainService.getAllTimerInfos("",app,bingTask));
        //request.setAttribute("app",tasktype);
        request.setAttribute("typeList",mainService.getApps());
        request.setAttribute("bingTask",ServiceUtil.serialNumber());
        request.setAttribute("app",app);
        request.setAttribute("timeFrame",timeFrame);
        request.setAttribute("taskstate",taskstate);*/
        return "templates/allnow";
    }

    @RequestMapping("errottask")
    public String errottask(String name,HttpServletRequest request) throws Exception {
        List<TaskInfo> taskInfos=  taskInfoService.dayErrorList(name);
        request.setAttribute("taskInfos",taskInfos);
        request.setAttribute("time",DateUtil.dateFormatDate());
        request.setAttribute("name",name);
        return "templates/history";
    }



    @RequestMapping("exception")
    public String exception(String id, @RequestParam(defaultValue = "1") int page,
                            @RequestParam(defaultValue = "10") int size
                            ,@RequestParam(name = "type",required = false,defaultValue = "") String type
                    ) throws Exception {

        JSONObject list=exceptionService.list(id,page,size,type);
        request().setAttribute("obj",list);
        return "templates/exception";
    }

    @RequestMapping("scheduleconfig")
    public String scheduleConfig() throws Exception {
        List<Table> list=this.mainService.tableInfo("not");
        request().setAttribute("list",list);
        return "templates/main/scheduleconfig";
    }

    @RequestMapping("tableinfo")
    public String tableinfo(String type) throws Exception {
        List<Table> list=this.mainService.tableInfo(type);
        request().setAttribute("list",list);
        request().setAttribute("type",type);
        return "templates/mapper/tableinfo";
    }

    @RequestMapping("mapperdetail")
    public String mapperdetail(String id,HttpServletRequest request) throws Exception {
        Table table=this.mapperService.tableinfo(id);
        Sql sql=this.mapperService.sqlInfo(id);
        List<Column> columns=this.mapperService.columnList(table);
        List dbs=this.mainService.getDbs();
        List support=this.mainService.supportDialect("source");
        List targetSupport=this.mainService.supportDialect("target");
        request.setAttribute("support",support);
        request.setAttribute("targetSupport",targetSupport);
        request.setAttribute("dbs",dbs);
        request.setAttribute("table",table);
        request.setAttribute("sql",sql);
        request.setAttribute("columns",columns);
        return "templates/mapper/mapperdetail";
    }

    @RequestMapping("datamapper")
    public String datamapper(HttpServletRequest request) throws Exception {
        List dbs=this.mainService.getDbs();
        request.setAttribute("dbs",dbs);

        List support=this.mainService.supportDialect("source");
        request.setAttribute("support",support);

        List targetSupport=this.mainService.supportDialect("target");
        request.setAttribute("targetSupport",targetSupport);

        return "templates/mapper/datamapper";
    }

    @RequestMapping("datamappers")
    public String datamappers(HttpServletRequest request) throws Exception {
        List dbs=this.mainService.getDbs();
        request.setAttribute("dbs",dbs);
        List support=this.mainService.supportDialect("source");
        request.setAttribute("support",support);
        List targetSupport=this.mainService.supportDialect("target");
        request.setAttribute("targetSupport",targetSupport);
        return "templates/mapper/datamappers";
    }

    @RequestMapping("datasource")
    public String datasource(HttpServletRequest request) throws Exception {
        return "templates/datasource/main";
    }

    @RequestMapping("toAdd")
    public String toAdd(HttpServletRequest request) throws Exception {
        return "templates/datasource/toAdd";
    }

    @RequestMapping("toUpd")
    public String toUpd(String id,HttpServletRequest request) throws Exception {
        request.setAttribute("id",id);
        return "templates/datasource/toUpd";
    }


    @RequestMapping("excel")
    public String excel(HttpServletRequest request) throws Exception {
        List dbs=this.mainService.getDbs();
        request.setAttribute("dbs",dbs);
        List support=this.mainService.supportDialect("source");
        request.setAttribute("support",support);
        List targetSupport=this.mainService.supportDialect("target");
        request.setAttribute("targetSupport",targetSupport);
        return "templates/excel/excel";
    }


    @RequestMapping("exceinfo")
    public String exceinfo() throws Exception {

        return "templates/excel/excelinfo";
    }

    @RequestMapping("updateTask")
    public String updateTask(String id,HttpServletRequest request) throws Exception {
        request.setAttribute("id",id);
        return "templates/main/updateTask";
    }

}
