package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.init.BaseSysinitBean;
import com.github.niupengyu.schedule.distributed.client.service.ClientHandlerService;
import com.github.niupengyu.schedule.distributed.init.Init;
import com.github.niupengyu.schedule.distributed.master.service.ServerHandlerService;
import com.github.niupengyu.web.content.ClientContent;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping("distributePage")
public class DistributedPageController extends ClientContent{

    @RequestMapping("mains")
    public String mains(HttpServletRequest request){
        request.setAttribute("model",Init.getModel());
        if(Init.client()){
            ClientHandlerService clientHandlerService= BaseSysinitBean.getBean("clientHandlerService");
            request.setAttribute("server",clientHandlerService.getClientConfig());
            String status=clientHandlerService.getStatus();
            request.setAttribute("status",status);
            request.setAttribute("clients",clientHandlerService.nodeList());
            if(status.equals("OFFLINE")){
                return "templates/distribute/offline";
            }else{
                return "templates/distribute/online";
            }
        }
        if(Init.server()){
            ServerHandlerService serverHandlerService=BaseSysinitBean.getBean("serverHandlerService");
            request.setAttribute("clients",serverHandlerService.taskList());
            return "templates/distribute/server";
        }
        return "templates/distribute/main";
    }
}
