package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.annotation.AutoConfig;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.beans.Node;
import com.github.niupengyu.schedule.distributed.init.Init;
import com.github.niupengyu.schedule.mains.service.DistributedService;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RequestMapping;
import javax.annotation.Resource;
import java.util.Collection;

@RestController
@RequestMapping("distribute")
@AutoConfig(name="news.server.enable")
public class DistributedController extends ClientContent{

    public DistributedController(){

    }

    @Resource(name="mainService")
    private MainService mainService;

    @Resource(name="distributedService")
    private DistributedService distributedService;

    @RequestMapping(value="startnow")
    public ResponseData startNow(@RequestBody TimerParam param) throws Exception {
        if(Init.none()){
            mainService.startNow(param);
        }else if(Init.server()){
            distributedService.startNow(param);
        }else{

        }
        return this.rdSuccess();
    }

    @RequestMapping(value="stopnow")
    public ResponseData stopnow(@RequestBody TimerParam param) throws Exception {
        mainService.stopNow(param);
        return this.rdSuccess();
    }

    @RequestMapping(value="stop")
    public ResponseData stop(String key) throws Exception {
        mainService.stop(key);
        return this.rdSuccess();
    }

    @RequestMapping(value="add")
    public ResponseData add(String key,String cron) throws Exception{
        System.out.println("key = [" + key + "], cron = [" + cron + "]");
        mainService.add(key,cron);
        return this.rdSuccess();
    }

    @RequestMapping(value="infos")
    public ResponseData infos(String type,String app)  {
        System.out.println("type = [" + type + "], app = [" + app + "]");
        Collection<Node> map=distributedService.getTimerInfos(type,app);
        return this.rdSuccess(map);
    }
}
