package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.mains.service.DbService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.alibaba.fastjson.JSONArray;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("dbinfo")
public class DbController extends ClientContent {

    @Resource(name = "dbService")
    private DbService dbService;

    @RequestMapping("pool")
    public ResponseData poolInfo(){

        JSONArray array=dbService.poolInfo();
        return this.rdSuccess(array);
    }

    @RequestMapping("taskinfo")
    public ResponseData taskinfo(@RequestBody String name){

        List<TaskInfo> array=dbService.taskinfo(name);

        return this.rdSuccess(array);
    }

    @RequestMapping("dbList")
    public ResponseData dbList(){
        return this.rdSuccess(dbService.list());
    }

    @RequestMapping("testConn")
    public ResponseData testConn(String id){
        return this.rdSuccess(dbService.testConnection(id));
    }

    @RequestMapping("testConn1")
    public ResponseData testConn1(DbInfo dbInfo){
        return this.rdSuccess(dbService.testConnection(dbInfo));
    }

    @RequestMapping("testDs")
    public ResponseData testDs(String id){
        //return this.rdSuccess(dbService.testDataSource(id));
        return this.rdSuccess();
    }


    @RequestMapping("stopDb")
    public ResponseData stopDb(String id){
        dbService.stopDb(id);
        return this.rdSuccess();
    }

    @RequestMapping("startDb")
    public ResponseData startDb(String id){
        dbService.startDb(id);
        return this.rdSuccess();
    }

    @RequestMapping("refresh")
    public ResponseData refresh(){
        dbService.refresh();
        return this.rdSuccess();
    }

    @RequestMapping("save")
    public ResponseData save(DbInfo dbInfo){
        dbService.save(dbInfo);
        return this.rdSuccess();
    }

    @RequestMapping("update")
    public ResponseData update(DbInfo dbInfo){
        dbService.update(dbInfo);
        return this.rdSuccess();
    }

    @RequestMapping("dbSupports")
    public ResponseData dbSupports(DbInfo dbInfo){
        return this.rdSuccess(SqlFactory.getDbMap().keySet());
    }


    @RequestMapping("test")
    public ResponseData test(String name){
        List<TaskInfo> array=dbService.test(name);
        //JSON.DEFFAULT_DATE_FORMAT="yyyy-MM-dd HH:mm:ss";
        return this.rdSuccess(array);
    }

    @RequestMapping("dialect")
    public ResponseData dialect(){

        List array=dbService.dialects();
        return this.rdSuccess(array);

    }

    @RequestMapping("database")
    public ResponseData database(){

        List array=dbService.database();
        return this.rdSuccess(array);

    }

    @RequestMapping("getById")
    public ResponseData getById(String id){

        DbInfo array=dbService.getById(id);
        return this.rdSuccess(array);

    }

}
