package com.github.niupengyu.schedule.mains.bean;

import com.github.niupengyu.core.util.ThreadLocalDateUtil;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

import java.util.Date;

public class Plan {

    private String id;

    private String name;

    private String task;

    private String cron;

    private int hours;

    private String start;

    private int count;

    private Date exe;

    private String end;

    private String dataStart;

    private String dataEnd;

    private int success;

    private int error;

    private int state;

    private int total;

    private int currentBatch;

    private int batchTotal;

    private int localPage;

    private int totalPage;

    private int size;

    private String status="NONE";

    private String bean;

    private String previousFireTime;

    private String nextFireTime;

    private String createDate;

    public void init(Scheduler scheduler){
        TriggerKey tk=TriggerKey.triggerKey(id+"trigger",
                "planTriggerGroup");

        try{
            Trigger t=scheduler.getTrigger(tk);
            if(t!=null){
                nextFireTime=value(t.getNextFireTime());
                previousFireTime=value(t.getPreviousFireTime());
                this.status=scheduler.getTriggerState(tk).name();
            }else{

            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    private String value(Date date) {
        if(date!=null){
            return ThreadLocalDateUtil.formatDate(date,1);
        }
        return "0";
    }

    public String getPreviousFireTime() {
        return previousFireTime;
    }

    public void setPreviousFireTime(String previousFireTime) {
        this.previousFireTime = previousFireTime;
    }

    public String getNextFireTime() {
        return nextFireTime;
    }

    public void setNextFireTime(String nextFireTime) {
        this.nextFireTime = nextFireTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getExe() {
        return exe;
    }

    public void setExe(Date exe) {
        this.exe = exe;
    }

    public int getSize() {
        return size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getBean() {
        return bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTask() {
        return task;
    }

    public void setTask(String task) {
        this.task = task;
    }

    public String getCron() {
        return cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public int getHours() {
        return hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getDataStart() {
        return dataStart;
    }

    public void setDataStart(String dataStart) {
        this.dataStart = dataStart;
    }

    public String getDataEnd() {
        return dataEnd;
    }

    public void setDataEnd(String dataEnd) {
        this.dataEnd = dataEnd;
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getCurrentBatch() {
        return currentBatch;
    }

    public void setCurrentBatch(int currentBatch) {
        this.currentBatch = currentBatch;
    }

    public int getBatchTotal() {
        return batchTotal;
    }

    public void setBatchTotal(int batchTotal) {
        this.batchTotal = batchTotal;
    }

    public int getLocalPage() {
        return localPage;
    }

    public void setLocalPage(int localPage) {
        this.localPage = localPage;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getSuccess() {
        return success;
    }

    public void setSuccess(int success) {
        this.success = success;
    }

    public int getError() {
        return error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int getState() {
        return state;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Override
    public String toString() {
        return "Plan{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", task='" + task + '\'' +
                ", cron='" + cron + '\'' +
                ", hours=" + hours +
                ", start='" + start + '\'' +
                ", count=" + count +
                ", exe=" + exe +
                ", end='" + end + '\'' +
                ", dataStart='" + dataStart + '\'' +
                ", dataEnd='" + dataEnd + '\'' +
                ", success=" + success +
                ", error=" + error +
                ", state=" + state +
                ", total=" + total +
                ", currentBatch=" + currentBatch +
                ", batchTotal=" + batchTotal +
                ", localPage=" + localPage +
                ", totalPage=" + totalPage +
                ", size=" + size +
                ", status='" + status + '\'' +
                ", bean='" + bean + '\'' +
                ", previousFireTime='" + previousFireTime + '\'' +
                ", nextFireTime='" + nextFireTime + '\'' +
                '}';
    }
}
