/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.generate.service;

import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.generate.util.GenUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class ScheduleGenerate {
    static Configuration cfg = null;
    static String groupId;
    static String packageName;
    static String version;
    static boolean tomcat;
    static String path;
    static String projectPath;
    static String name;

    public static void main(String[] args) throws Exception {
        ScheduleGenerate.exe();
    }

    public static void exe() throws Exception {
        String[] modules;
        String group = "com.ultrapower.df.";
        path = "d:\\data\\project";
        String projectName = "hczz";
        boolean webapp = true;
        String moduleName = "schedule";
        tomcat = false;
        if (StringUtil.isNull((Object)moduleName)) {
            name = projectName;
            groupId = projectName;
            packageName = projectName;
            version = projectName + ".version";
        } else {
            name = projectName + "-" + moduleName;
            groupId = group + projectName + "." + moduleName;
            version = projectName + "." + moduleName + ".version";
            packageName = projectName + "\\" + moduleName;
        }
        projectPath = path + "\\" + name;
        File file = new File(projectPath);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        String projectPom = projectPath + "\\pom.xml";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupId", groupId);
        map.put("name", name);
        map.put("version", "${" + version + "}");
        map.put("versionName", version);
        cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDirectoryForTemplateLoading(new File("D:\\data\\project\\tem"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template template = cfg.getTemplate("schedule/pom.ftl");
        File docFile = new File(projectPom);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(docFile)));
        template.process(map, (Writer)out);
        FileUtil.close((Writer)out);
        out = null;
        for (String mo : modules = new String[]{"service"}) {
            ScheduleGenerate.genMo(mo, name, projectPath, packageName, map, cfg);
        }
        ScheduleGenerate.genStarter(name, projectPath, packageName, map, cfg, webapp);
        ScheduleGenerate.genWebJava();
    }

    private static void genWebJava() throws Exception {
        String[] mos = new String[]{"service"};
        HashMap<String, String[]> java = new HashMap<String, String[]>();
        java.put("service", new String[]{"XsJjdbDeleteTask", "XsJjdbTask", "DeptDeleteTest"});
        for (String mo : mos) {
            String[] j;
            String packagePath = ScheduleGenerate.moClassPath(mo);
            String pack = groupId + "." + mo;
            String tempJava = packagePath + "\\Temp.java";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pack", pack);
            map.put("groupId", groupId);
            GenUtil.genFile(cfg, tempJava, "temp", map);
            String sysPackagePath = packagePath + "\\sys";
            FileUtil.mkdirs((String)sysPackagePath);
            for (String n : j = (String[])java.get(mo)) {
                String path = sysPackagePath + "\\" + n + ".java";
                GenUtil.genFile(cfg, path, "schedule/" + n, map);
            }
            sysPackagePath = packagePath + "\\mapper\\mysql";
            FileUtil.mkdirs((String)sysPackagePath);
            String path = sysPackagePath + "\\MysqlMapper.java";
            GenUtil.genFile(cfg, path, "schedule/MysqlMapper", map);
            path = sysPackagePath + "\\MySqlXsMapper.java";
            GenUtil.genFile(cfg, path, "schedule/MySqlXsMapper", map);
            sysPackagePath = packagePath + "\\mapper\\oracle";
            FileUtil.mkdirs((String)sysPackagePath);
            path = sysPackagePath + "\\MysqlMapper1.java";
            GenUtil.genFile(cfg, path, "schedule/MysqlMapper1", map);
            path = sysPackagePath + "\\OracleXsMapper.java";
            GenUtil.genFile(cfg, path, "schedule/OracleXsMapper", map);
        }
    }

    private static String moPath(String mo) {
        return projectPath + "\\" + ScheduleGenerate.moduleName(mo);
    }

    private static String moClassPath(String mo) {
        return ScheduleGenerate.moPath(mo) + "\\src\\main\\java\\com\\ultrapower\\df\\" + packageName + "\\" + mo;
    }

    private static String moduleName(String mo) {
        return name + "-" + mo;
    }

    private static void genStarter(String name, String projectPath, String packageName, Map<String, String> map, Configuration cfg, boolean webapp) throws Exception {
        String logbacks;
        String xmlBase;
        String resourceDir;
        String mo = "zstarter";
        ScheduleGenerate.genMo(mo, name, projectPath, packageName, map, cfg);
        String moduleNames = ScheduleGenerate.moduleName(mo);
        String mBase = projectPath + "\\" + "" + moduleNames;
        String packgetPath = mBase + "\\src\\main\\java\\com\\ultrapower\\df\\" + packageName + "\\" + mo;
        HashMap<String, String> startMap = new HashMap<String, String>();
        startMap.put("basePath", groupId);
        startMap.put("packagePath", groupId + "." + mo);
        GenUtil.genFile(cfg, packgetPath + "\\Starter.java", "schedule/Starter", startMap);
        if (tomcat) {
            resourceDir = mBase + "\\src\\main\\resources";
            xmlBase = "mybatis";
            logbacks = "../logbacks";
        } else {
            resourceDir = mBase + "\\config";
            xmlBase = "file:config/mybatis";
            logbacks = "logbacks";
        }
        FileUtil.mkdirs1((String)resourceDir);
        String application = resourceDir + "\\application.yml";
        String applicationDev = resourceDir + "\\application-dev.yml";
        String applicationTest = resourceDir + "\\application-test.yml";
        String applicationPro = resourceDir + "\\application-pro.yml";
        String log4j = resourceDir + "\\log4j.xml";
        String mybatisDir = resourceDir + "\\mybatis";
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        resourceMap.put("groupId", groupId);
        resourceMap.put("logbacks", logbacks);
        resourceMap.put("xmlBase", xmlBase);
        GenUtil.genFile(cfg, application, "application", resourceMap);
        GenUtil.genFile(cfg, applicationDev, "application-temp", resourceMap);
        GenUtil.genFile(cfg, applicationTest, "application-temp", resourceMap);
        GenUtil.genFile(cfg, applicationPro, "application-temp", resourceMap);
        GenUtil.genFile(cfg, log4j, "log4j", resourceMap);
        FileUtil.mkdirs((String)mybatisDir);
        if (webapp) {
            String webappFile = mBase + "\\src\\main\\webapp";
            FileUtil.mkdirs1((String)webappFile);
            String webappDir = path + "\\tem\\schedule\\webapp";
            FileUtils.copyDirectory((File)new File(webappDir), (File)new File(webappFile));
        }
    }

    private static void genMo(String mo, String name, String projectPath, String packageName, Map map, Configuration cfg) throws Exception {
        String moduleNames = name + "-" + mo;
        String mBase = ScheduleGenerate.moPath(mo);
        String mJavaFile = ScheduleGenerate.moClassPath(mo);
        String mTestFile = mBase + "\\src\\test";
        String mTargetFile = mBase + "\\target";
        String mPomFile = mBase + "\\pom.xml";
        FileUtil.mkdirs1((String)mJavaFile);
        FileUtil.mkdirs1((String)mTestFile);
        FileUtil.mkdirs1((String)mTargetFile);
        map.put("moduleNames", moduleNames);
        GenUtil.genFile(cfg, mPomFile, "schedule/" + mo, map);
    }
}

