/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.generate.service;

import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.generate.util.GenUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class ProGenerate {
    static Configuration cfg = null;
    static String groupId;
    static String packageName;
    static String version;
    static boolean tomcat;
    static String path;
    static String projectPath;
    static String name;

    public static void exe() throws Exception {
        String[] modules;
        String group = "com.ultrapower.df.";
        path = "d:\\data\\project";
        String projectName = "guiyjz";
        boolean webapp = true;
        String moduleName = "evaluation2";
        tomcat = true;
        if (StringUtil.isNull((Object)moduleName)) {
            name = projectName;
            groupId = projectName;
            packageName = projectName;
            version = projectName + ".version";
        } else {
            name = projectName + "-" + moduleName;
            groupId = group + projectName + "." + moduleName;
            version = projectName + "." + moduleName + ".version";
            packageName = projectName + "\\" + moduleName;
        }
        projectPath = path + "\\" + name;
        File file = new File(projectPath);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        String projectPom = projectPath + "\\pom.xml";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupId", groupId);
        map.put("name", name);
        map.put("version", "${" + version + "}");
        map.put("versionName", version);
        cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDirectoryForTemplateLoading(new File("D:\\data\\project\\tem"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template template = cfg.getTemplate("pom.ftl");
        File docFile = new File(projectPom);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(docFile)));
        template.process(map, (Writer)out);
        System.out.println("^^^^^^^^^^^^^^^^^^^^^^^^User.java \u6587\u4ef6\u521b\u5efa\u6210\u529f !");
        FileUtil.close((Writer)out);
        out = null;
        for (String mo : modules = new String[]{"beans", "common", "dao", "service", "web"}) {
            ProGenerate.genMo(mo, name, projectPath, packageName, map, cfg);
        }
        ProGenerate.genStarter(name, projectPath, packageName, map, cfg, webapp);
        ProGenerate.genWebJava();
    }

    private static void genWebJava() throws Exception {
        String[] mos = new String[]{"web"};
        HashMap<String, String[]> java = new HashMap<String, String[]>();
        java.put("web", new String[]{"TestRestController", "TestPageController"});
        java.put("dao", new String[]{"TestDao"});
        java.put("service", new String[]{"TestService"});
        java.put("beans", new String[]{"Test"});
        for (String mo : mos) {
            String[] j;
            String packagePath = ProGenerate.moClassPath(mo);
            String pack = groupId + "." + mo;
            String tempJava = packagePath + "\\Temp.java";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pack", pack);
            map.put("groupId", groupId);
            GenUtil.genFile(cfg, tempJava, "temp", map);
            String sysPackagePath = packagePath + "\\sys";
            for (String n : j = (String[])java.get(mo)) {
                String path = sysPackagePath + "\\" + n + ".java";
                GenUtil.genFile(cfg, path, "java/" + n, map);
            }
        }
    }

    private static String moPath(String mo) {
        return projectPath + "\\" + ProGenerate.moduleName(mo);
    }

    private static String moClassPath(String mo) {
        return ProGenerate.moPath(mo) + "\\src\\main\\java\\com\\ultrapower\\df\\" + packageName + "\\" + mo;
    }

    private static String moduleName(String mo) {
        return name + "-" + mo;
    }

    private static void genStarter(String name, String projectPath, String packageName, Map<String, String> map, Configuration cfg, boolean webapp) throws Exception {
        String logbacks;
        String xmlBase;
        String resourceDir;
        String mo = "zstarter";
        ProGenerate.genMo(mo, name, projectPath, packageName, map, cfg);
        String moduleNames = ProGenerate.moduleName(mo);
        String mBase = projectPath + "\\" + "" + moduleNames;
        String packgetPath = mBase + "\\src\\main\\java\\com\\ultrapower\\df\\" + packageName + "\\" + mo;
        HashMap<String, String> startMap = new HashMap<String, String>();
        startMap.put("basePath", groupId);
        startMap.put("packagePath", groupId + "." + mo);
        GenUtil.genFile(cfg, packgetPath + "\\Starter.java", "starterClass", startMap);
        if (tomcat) {
            resourceDir = mBase + "\\src\\main\\resources";
            xmlBase = "mybatis";
            logbacks = "../logbacks";
        } else {
            resourceDir = mBase + "\\config";
            xmlBase = "file:config/mybatis";
            logbacks = "logbacks";
        }
        FileUtil.mkdirs1((String)resourceDir);
        String application = resourceDir + "\\application.yml";
        String applicationDev = resourceDir + "\\application-dev.yml";
        String applicationTest = resourceDir + "\\application-test.yml";
        String applicationPro = resourceDir + "\\application-pro.yml";
        String log4j = resourceDir + "\\log4j.xml";
        String mybatisDir = resourceDir + "\\mybatis";
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        resourceMap.put("groupId", groupId);
        resourceMap.put("logbacks", logbacks);
        resourceMap.put("xmlBase", xmlBase);
        GenUtil.genFile(cfg, application, "application", resourceMap);
        GenUtil.genFile(cfg, applicationDev, "application-temp", resourceMap);
        GenUtil.genFile(cfg, applicationTest, "application-temp", resourceMap);
        GenUtil.genFile(cfg, applicationPro, "application-temp", resourceMap);
        GenUtil.genFile(cfg, log4j, "log4j", resourceMap);
        FileUtil.mkdirs((String)mybatisDir);
        if (webapp) {
            String webappFile = mBase + "\\src\\main\\webapp";
            FileUtil.mkdirs1((String)webappFile);
            String pagePath = webappFile + "\\pages";
            String staticPath = webappFile + "\\static";
            String webPath = webappFile + "\\WEB-INF";
            String indexPath = webappFile + "\\index.jsp";
            String jsPath = staticPath + "\\js";
            String cssPath = staticPath + "\\css";
            String imagePath = staticPath + "\\image";
            String jspPath = pagePath + "\\jsp";
            String templatesPath = pagePath + "\\templates";
            FileUtil.mkdirs1((String)webPath);
            FileUtil.mkdirs1((String)indexPath);
            FileUtil.mkdirs1((String)jsPath);
            FileUtil.mkdirs1((String)cssPath);
            FileUtil.mkdirs1((String)imagePath);
            FileUtil.mkdirs1((String)jspPath);
            FileUtil.mkdirs1((String)templatesPath);
            String webXml = webPath + "\\web.xml";
            GenUtil.genFile(cfg, webXml, "webxml", new HashMap());
        }
    }

    private static void genMo(String mo, String name, String projectPath, String packageName, Map map, Configuration cfg) throws Exception {
        String moduleNames = name + "-" + mo;
        String mBase = ProGenerate.moPath(mo);
        String mJavaFile = ProGenerate.moClassPath(mo);
        String mTestFile = mBase + "\\src\\test";
        String mTargetFile = mBase + "\\target";
        String mPomFile = mBase + "\\pom.xml";
        FileUtil.mkdirs1((String)mJavaFile);
        FileUtil.mkdirs1((String)mTestFile);
        FileUtil.mkdirs1((String)mTargetFile);
        map.put("moduleNames", moduleNames);
        GenUtil.genFile(cfg, mPomFile, mo, map);
    }
}

