/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util.system;

import com.github.niupengyu.core.util.data.NumberUtil;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import oshi.json.SystemInfo;
import oshi.json.hardware.CentralProcessor;
import oshi.json.hardware.GlobalMemory;
import oshi.json.hardware.HWDiskStore;
import oshi.json.hardware.HardwareAbstractionLayer;

public class SystemUsageUtil {
    private SystemInfo systemInfo = new SystemInfo();
    private HardwareAbstractionLayer hal = this.systemInfo.getHardware();

    public double getMemoryUsage() {
        this.hal = this.systemInfo.getHardware();
        GlobalMemory memory = this.hal.getMemory();
        double available = memory.getAvailable();
        double total = memory.getTotal();
        double useRate = NumberUtil.decimalFormat(available / total, 4);
        return useRate;
    }

    public double getCpuUsage() {
        this.hal = this.systemInfo.getHardware();
        CentralProcessor processor = this.hal.getProcessor();
        double useRate = processor.getSystemCpuLoadBetweenTicks();
        return NumberUtil.decimalFormat(useRate, 4);
    }

    public double getDiskUsage() {
        if (SystemUsageUtil.isWindows()) {
            return this.getWinDiskUsage();
        }
        return this.getUnixDiskUsage();
    }

    private static boolean isWindows() {
        return System.getProperties().getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    private double getUnixDiskUsage() {
        String ioCmdStr = "df -h /";
        String resultInfo = this.runCommand(ioCmdStr);
        String[] data = resultInfo.split(" +");
        double total = Double.parseDouble(data[10].replace("%", ""));
        return total / 100.0;
    }

    public String serialNumber() {
        return this.hal.getComputerSystem().getSerialNumber();
    }

    private double getWinDiskUsage() {
        this.hal = this.systemInfo.getHardware();
        HWDiskStore[] diskStores = this.hal.getDiskStores();
        double total = 0.0;
        double used = 0.0;
        if (diskStores != null && diskStores.length > 0) {
            for (HWDiskStore diskStore : diskStores) {
                double size = diskStore.getSize();
                double writeBytes = diskStore.getWriteBytes();
                total += size;
                used += writeBytes;
            }
        }
        return NumberUtil.decimalFormat(used / total, 4);
    }

    private String runCommand(String CMD) {
        StringBuilder info = new StringBuilder();
        try {
            String line;
            Process pos = Runtime.getRuntime().exec(CMD);
            pos.waitFor();
            InputStreamReader isr = new InputStreamReader(pos.getInputStream());
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((line = lnr.readLine()) != null) {
                info.append(line).append("\n");
            }
        }
        catch (Exception e) {
            info = new StringBuilder(e.toString());
        }
        return info.toString();
    }
}

