/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util.system;

import java.util.Arrays;
import java.util.List;
import org.threeten.bp.LocalDate;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Display;
import oshi.hardware.Firmware;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.hardware.PowerSource;
import oshi.hardware.Sensors;
import oshi.hardware.UsbDevice;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.Util;

public class SystemInfoUtil {
    private static void printComputerSystem(ComputerSystem computerSystem) {
        System.out.println("manufacturer: " + computerSystem.getManufacturer());
        System.out.println("model: " + computerSystem.getModel());
        System.out.println("serialnumber: " + computerSystem.getSerialNumber());
        Firmware firmware = computerSystem.getFirmware();
        System.out.println("firmware:");
        System.out.println("  manufacturer: " + firmware.getManufacturer());
        System.out.println("  name: " + firmware.getName());
        System.out.println("  description: " + firmware.getDescription());
        System.out.println("  version: " + firmware.getVersion());
        System.out.println("  release date: " + (firmware.getReleaseDate() == null ? "unknown" : (firmware.getReleaseDate() == null ? "unknown" : FormatUtil.formatDate((LocalDate)firmware.getReleaseDate()))));
        Baseboard baseboard = computerSystem.getBaseboard();
        System.out.println("baseboard:");
        System.out.println("  manufacturer: " + baseboard.getManufacturer());
        System.out.println("  model: " + baseboard.getModel());
        System.out.println("  version: " + baseboard.getVersion());
        System.out.println("  serialnumber: " + baseboard.getSerialNumber());
    }

    private static void printProcessor(CentralProcessor processor) {
        System.out.println(processor);
        System.out.println(" " + processor.getPhysicalProcessorCount() + " physical CPU(s)");
        System.out.println(" " + processor.getLogicalProcessorCount() + " logical CPU(s)");
        System.out.println("Identifier: " + processor.getIdentifier());
        System.out.println("ProcessorID: " + processor.getProcessorID());
    }

    private static void printMemory(GlobalMemory memory) {
        System.out.println("\u4ee5\u4f7f\u7528\u5185\u5b58: " + FormatUtil.formatBytes((long)memory.getAvailable()) + "\u603b\u5171\u5185\u5b58" + FormatUtil.formatBytes((long)memory.getTotal()));
        System.out.println("Swap used: " + FormatUtil.formatBytes((long)memory.getSwapUsed()) + "/" + FormatUtil.formatBytes((long)memory.getSwapTotal()));
    }

    private static void printCpu(CentralProcessor processor) {
        double[] load;
        System.out.println("Uptime: " + FormatUtil.formatElapsedSecs((long)processor.getSystemUptime()));
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        System.out.println("CPU, IOWait, and IRQ ticks @ 0 sec:" + Arrays.toString(prevTicks));
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        System.out.println("CPU, IOWait, and IRQ ticks @ 1 sec:" + Arrays.toString(ticks));
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long sys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long totalCpu = user + nice + sys + idle + iowait + irq + softirq + steal;
        System.out.format("User: %.1f%% Nice: %.1f%% System: %.1f%% Idle: %.1f%% IOwait: %.1f%% IRQ: %.1f%% SoftIRQ: %.1f%% Steal: %.1f%%%n", 100.0 * (double)user / (double)totalCpu, 100.0 * (double)nice / (double)totalCpu, 100.0 * (double)sys / (double)totalCpu, 100.0 * (double)idle / (double)totalCpu, 100.0 * (double)iowait / (double)totalCpu, 100.0 * (double)irq / (double)totalCpu, 100.0 * (double)softirq / (double)totalCpu, 100.0 * (double)steal / (double)totalCpu);
        System.out.format("CPU load: %.1f%% (counting ticks)%n", processor.getSystemCpuLoadBetweenTicks() * 100.0);
        System.out.format("CPU load: %.1f%% (OS MXBean)%n", processor.getSystemCpuLoad() * 100.0);
        double[] loadAverage = processor.getSystemLoadAverage(3);
        System.out.println("CPU load averages:" + (loadAverage[0] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[0])) + (loadAverage[1] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[1])) + (loadAverage[2] < 0.0 ? " N/A" : String.format(" %.2f", loadAverage[2])));
        StringBuilder procCpu = new StringBuilder("CPU load per processor:");
        for (double avg : load = processor.getProcessorCpuLoadBetweenTicks()) {
            procCpu.append(String.format(" %.1f%%", avg * 100.0));
        }
        System.out.println(procCpu.toString());
    }

    private static void printProcesses(OperatingSystem os, GlobalMemory memory) {
        System.out.println("Processes: " + os.getProcessCount() + ", Threads: " + os.getThreadCount());
        List<OSProcess> procs = Arrays.asList(os.getProcesses(5, OperatingSystem.ProcessSort.CPU));
        System.out.println("   PID  %CPU %MEM       VSZ       RSS Name");
        for (int i = 0; i < procs.size() && i < 5; ++i) {
            OSProcess p = procs.get(i);
            System.out.format(" %5d %5.1f %4.1f %9s %9s %s%n", p.getProcessID(), 100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime(), 100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal(), FormatUtil.formatBytes((long)p.getVirtualSize()), FormatUtil.formatBytes((long)p.getResidentSetSize()), p.getName());
        }
    }

    private static void printSensors(Sensors sensors) {
        System.out.println("Sensors:");
        System.out.format(" CPU Temperature: %.1f\u00b0C%n", sensors.getCpuTemperature());
        System.out.println(" Fan Speeds: " + Arrays.toString(sensors.getFanSpeeds()));
        System.out.format(" CPU Voltage: %.1fV%n", sensors.getCpuVoltage());
    }

    private static void printPowerSources(PowerSource[] powerSources) {
        StringBuilder sb = new StringBuilder("Power: ");
        if (powerSources.length == 0) {
            sb.append("Unknown");
        } else {
            double timeRemaining = powerSources[0].getTimeRemaining();
            if (timeRemaining < -1.0) {
                sb.append("Charging");
            } else if (timeRemaining < 0.0) {
                sb.append("Calculating time remaining");
            } else {
                sb.append(String.format("%d:%02d remaining", (int)(timeRemaining / 3600.0), (int)(timeRemaining / 60.0) % 60));
            }
        }
        for (PowerSource pSource : powerSources) {
            sb.append(String.format("%n %s @ %.1f%%", pSource.getName(), pSource.getRemainingCapacity() * 100.0));
        }
        System.out.println(sb.toString());
    }

    private static void printDisks(HWDiskStore[] diskStores) {
        System.out.println("Disks:");
        for (HWDiskStore disk : diskStores) {
            boolean readwrite = disk.getReads() > 0L || disk.getWrites() > 0L;
            System.out.format(" %s: (model: %s - S/N: %s) size: %s, reads: %s (%s), writes: %s (%s), xfer: %s ms%n", disk.getName(), disk.getModel(), disk.getSerial(), disk.getSize() > 0L ? FormatUtil.formatBytesDecimal((long)disk.getSize()) : "?", readwrite ? Long.valueOf(disk.getReads()) : "?", readwrite ? FormatUtil.formatBytes((long)disk.getReadBytes()) : "?", readwrite ? Long.valueOf(disk.getWrites()) : "?", readwrite ? FormatUtil.formatBytes((long)disk.getWriteBytes()) : "?", readwrite ? Long.valueOf(disk.getTransferTime()) : "?");
            HWPartition[] partitions = disk.getPartitions();
            if (partitions == null) continue;
            for (HWPartition part : partitions) {
                System.out.format(" |-- %s: %s (%s) Maj:Min=%d:%d, size: %s%s%n", part.getIdentification(), part.getName(), part.getType(), part.getMajor(), part.getMinor(), FormatUtil.formatBytesDecimal((long)part.getSize()), part.getMountPoint().isEmpty() ? "" : " @ " + part.getMountPoint());
            }
        }
    }

    private static void printFileSystem(FileSystem fileSystem) {
        OSFileStore[] fsArray;
        System.out.println("File System:");
        System.out.format(" File Descriptors: %d/%d%n", fileSystem.getOpenFileDescriptors(), fileSystem.getMaxFileDescriptors());
        for (OSFileStore fs : fsArray = fileSystem.getFileStores()) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            System.out.format(" %s (%s) [%s] %s of %s free (%.1f%%) is %s " + (fs.getLogicalVolume() != null && fs.getLogicalVolume().length() > 0 ? "[%s]" : "%s") + " and is mounted at %s%n", fs.getName(), fs.getDescription().isEmpty() ? "file system" : fs.getDescription(), fs.getType(), FormatUtil.formatBytes((long)usable), FormatUtil.formatBytes((long)fs.getTotalSpace()), 100.0 * (double)usable / (double)total, fs.getVolume(), fs.getLogicalVolume(), fs.getMount());
        }
    }

    private static void printNetworkInterfaces(NetworkIF[] networkIFs) {
        System.out.println("Network interfaces:");
        for (NetworkIF net : networkIFs) {
            System.out.format(" Name: %s (%s)%n", net.getName(), net.getDisplayName());
            System.out.format("   MAC Address: %s %n", net.getMacaddr());
            System.out.format("   MTU: %s, Speed: %s %n", net.getMTU(), FormatUtil.formatValue((long)net.getSpeed(), (String)"bps"));
            System.out.format("   IPv4: %s %n", Arrays.toString(net.getIPv4addr()));
            System.out.format("   IPv6: %s %n", Arrays.toString(net.getIPv6addr()));
            boolean hasData = net.getBytesRecv() > 0L || net.getBytesSent() > 0L || net.getPacketsRecv() > 0L || net.getPacketsSent() > 0L;
            System.out.format("   Traffic: received %s/%s%s; transmitted %s/%s%s %n", hasData ? net.getPacketsRecv() + " packets" : "?", hasData ? FormatUtil.formatBytes((long)net.getBytesRecv()) : "?", hasData ? " (" + net.getInErrors() + " err)" : "", hasData ? net.getPacketsSent() + " packets" : "?", hasData ? FormatUtil.formatBytes((long)net.getBytesSent()) : "?", hasData ? " (" + net.getOutErrors() + " err)" : "");
        }
    }

    private static void printNetworkParameters(NetworkParams networkParams) {
        System.out.println("Network parameters:");
        System.out.format(" Host name: %s%n", networkParams.getHostName());
        System.out.format(" Domain name: %s%n", networkParams.getDomainName());
        System.out.format(" DNS servers: %s%n", Arrays.toString(networkParams.getDnsServers()));
        System.out.format(" IPv4 Gateway: %s%n", networkParams.getIpv4DefaultGateway());
        System.out.format(" IPv6 Gateway: %s%n", networkParams.getIpv6DefaultGateway());
    }

    private static void printDisplays(Display[] displays) {
        System.out.println("Displays:");
        int i = 0;
        for (Display display : displays) {
            System.out.println(" Display " + i + ":");
            System.out.println(display.toString());
            ++i;
        }
    }

    private static void printUsbDevices(UsbDevice[] usbDevices) {
        System.out.println("USB Devices:");
        for (UsbDevice usbDevice : usbDevices) {
            System.out.println(usbDevice.toString());
        }
    }

    public static void info() {
        System.out.println("Initializing System...");
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        System.out.println(os);
        System.out.println("Checking computer system...");
        SystemInfoUtil.printComputerSystem(hal.getComputerSystem());
        System.out.println("Checking Processor...");
        SystemInfoUtil.printProcessor(hal.getProcessor());
        System.out.println("Checking Memory...");
        SystemInfoUtil.printMemory(hal.getMemory());
        System.out.println("Checking CPU...");
        SystemInfoUtil.printCpu(hal.getProcessor());
        System.out.println("Checking Processes...");
        SystemInfoUtil.printProcesses(os, hal.getMemory());
        System.out.println("Checking Sensors...");
        SystemInfoUtil.printSensors(hal.getSensors());
        System.out.println("Checking Power sources...");
        SystemInfoUtil.printPowerSources(hal.getPowerSources());
        System.out.println("Checking Disks...");
        SystemInfoUtil.printDisks(hal.getDiskStores());
        System.out.println("Checking File System...");
        SystemInfoUtil.printFileSystem(os.getFileSystem());
        System.out.println("Checking Network interfaces...");
        SystemInfoUtil.printNetworkInterfaces(hal.getNetworkIFs());
        System.out.println("Checking Network parameterss...");
        SystemInfoUtil.printNetworkParameters(os.getNetworkParams());
        System.out.println("Checking Displays...");
        SystemInfoUtil.printDisplays(hal.getDisplays());
        System.out.println("Checking USB Devices...");
        SystemInfoUtil.printUsbDevices(hal.getUsbDevices(true));
    }

    public static void main(String[] args) {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        OperatingSystem os = si.getOperatingSystem();
        SystemInfoUtil.printNetworkInterfaces(hal.getNetworkIFs());
        SystemInfoUtil.printNetworkParameters(os.getNetworkParams());
    }
}

