/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Random;

public class NumberUtil {
    private static String hexString = "0123456789ABCDEF";

    public static Long numberSize(Long num) {
        Long i = 1L;
        while (num / 10L > 0L) {
            num = num / 10L;
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
        return i;
    }

    public static Long floatByte(Long num, Long numSize) {
        int x = 1;
        Long i = 0L;
        while (i < numSize) {
            x *= 10;
            Long l = i;
            Long l2 = i = Long.valueOf(i + 1L);
        }
        return (long)x * num;
    }

    public String getdouble(double d, int w) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(w);
        return nf.format(d);
    }

    public static String genCode(int count) {
        String code = "";
        Random random = new Random();
        for (int i = 0; i < count; ++i) {
            code = code + (random.nextInt(8) + 1);
        }
        return code;
    }

    public static String str2HexStr2(String str) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder sb = new StringBuilder("");
        byte[] bs = str.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(chars[bit]);
            bit = bs[i] & 0xF;
            sb.append(chars[bit]);
        }
        return sb.toString().trim();
    }

    public static String byte2HexStr(byte[] b) {
        String stmp = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            sb.append(stmp.length() == 1 ? "0" + stmp : stmp);
        }
        return sb.toString().toUpperCase().trim();
    }

    public static int bytes2Int(byte[] bytes) {
        int num = bytes[3] & 0xFF;
        num |= bytes[2] << 8 & 0xFF00;
        num |= bytes[1] << 16 & 0xFF0000;
        return num |= bytes[0] << 24 & 0xFF0000;
    }

    public static byte[] int2Bytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static String toHexString(String s) {
        String str = "";
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            String s4 = Integer.toHexString(ch);
            str = str + s4;
        }
        return str;
    }

    public static String encode(String str) {
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    public static String decode(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return new String(baos.toByteArray());
    }

    public static String hexString2binaryString(String hexString) {
        if (hexString == null || hexString.length() % 2 != 0) {
            return null;
        }
        String bString = "";
        for (int i = 0; i < hexString.length(); ++i) {
            String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString = bString + tmp.substring(tmp.length() - 4);
        }
        return bString;
    }

    public byte[] getContent(String filePath) throws IOException {
        int offset;
        File file = new File(filePath);
        long fileSize = file.length();
        if (fileSize > Integer.MAX_VALUE) {
            return null;
        }
        FileInputStream fi = new FileInputStream(file);
        byte[] buffer = new byte[(int)fileSize];
        int numRead = 0;
        for (offset = 0; offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0; offset += numRead) {
        }
        if (offset != buffer.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fi.close();
        return buffer;
    }

    public static byte[] toByteArray3(String filename) throws IOException {
        AbstractInterruptibleChannel fc = null;
        try {
            fc = new RandomAccessFile(filename, "r").getChannel();
            MappedByteBuffer byteBuffer = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, ((FileChannel)fc).size()).load();
            byte[] result = new byte[(int)((FileChannel)fc).size()];
            if (byteBuffer.remaining() > 0) {
                byteBuffer.get(result, 0, byteBuffer.remaining());
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String parseDouble(double value, String reg) {
        DecimalFormat df = new DecimalFormat(reg);
        return df.format(value);
    }

    public static float percent(double count, double max, int i) {
        if (max == 0.0) {
            return 0.0f;
        }
        BigDecimal b = new BigDecimal(count / max * 100.0);
        float f1 = b.setScale(i, 4).floatValue();
        return f1;
    }

    public static float percent(double count, double max) {
        if (max == 0.0) {
            return 0.0f;
        }
        BigDecimal b = new BigDecimal(count / max * 100.0);
        float f1 = b.setScale(2, 4).floatValue();
        return f1;
    }

    public static String format(int num) {
        return String.format("%04d", num);
    }

    public static String format(int num, int size) {
        return String.format("%0" + size + "d", num);
    }

    public static String format(long num) {
        return String.format("%04d", num);
    }

    public static String format(long num, int size) {
        return String.format("%0" + size + "d", num);
    }

    public static String format(String format, int num) {
        return String.format(format, num);
    }

    public static HashSet<Integer> random(int size, int max) {
        HashSet<Integer> hs = new HashSet<Integer>();
        while (hs.size() != size) {
            int a = (int)(Math.random() * (double)max);
            if (a < 0 || a > max) continue;
            hs.add(a);
        }
        return hs;
    }

    public static double decimalFormat(double f, int i) {
        BigDecimal b = new BigDecimal(f);
        double f1 = b.setScale(i, 4).doubleValue();
        return f1;
    }

    public static int sum(int[] array) {
        int sum = 0;
        for (int i : array) {
            sum += i;
        }
        return sum;
    }

    public static void main(String[] args) {
        System.out.println(NumberUtil.percent(0.9, 16.0));
    }
}

