/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ZipTools {
    private OutputStream out = null;
    private BufferedOutputStream bos = null;
    private ZipArchiveOutputStream zaos = null;
    private String zipFileName = null;

    public static void main(String[] args) throws FileNotFoundException, Exception {
        ZipTools main = new ZipTools("E:\\apache-tomcat-6.0.35-windows-x86\\apache-tomcat-6.0.35\\webapps\\lybl\\fileupload\\zip\\1.zip");
        main.createZipOut();
        main.packToolFiles("E:\\apache-tomcat-6.0.35-windows-x86\\apache-tomcat-6.0.35\\webapps\\lybl\\fileupload\\scenic\\1", "");
        main.closeZipOut();
        System.out.println(System.getProperty("user.dir"));
    }

    public ZipTools(String zipname) {
        this.zipFileName = zipname;
    }

    public void createZipOut() throws FileNotFoundException, IOException {
        File f = new File(this.zipFileName);
        this.out = new FileOutputStream(f);
        this.bos = new BufferedOutputStream(this.out);
        this.zaos = new ZipArchiveOutputStream((OutputStream)this.bos);
        this.zaos.setEncoding("GBK");
    }

    public void closeZipOut() throws Exception {
        this.zaos.flush();
        this.zaos.close();
        this.bos.flush();
        this.bos.close();
        this.out.flush();
        this.out.close();
    }

    public void packToolFiles(String dirpath, String pathName) throws FileNotFoundException, IOException {
        if (!StringUtil.isNull(pathName)) {
            pathName = pathName + File.separator;
        }
        this.packToolFiles(this.zaos, dirpath, pathName);
    }

    public void packToolFiles(ZipArchiveOutputStream zaos, String dirpath, String pathName) throws FileNotFoundException, IOException {
        ByteArrayOutputStream tempbaos = new ByteArrayOutputStream();
        BufferedOutputStream tempbos = new BufferedOutputStream(tempbaos);
        File dir = new File(dirpath);
        File[] files = dir.listFiles();
        if (files == null || files.length < 1) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.packToolFiles(zaos, files[i].getAbsolutePath(), pathName + files[i].getName() + File.separator);
                continue;
            }
            zaos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(pathName + files[i].getName()));
            IOUtils.copy((InputStream)new FileInputStream(files[i].getAbsolutePath()), (OutputStream)zaos);
            zaos.closeArchiveEntry();
        }
        tempbaos.flush();
        tempbaos.close();
        tempbos.flush();
        tempbos.close();
    }

    public static void unZipToFolder(String zipfilename, String outputdir) throws IOException {
        ZipFile zf;
        File zipfile = new File(zipfilename);
        if (zipfile.exists()) {
            outputdir = outputdir + File.separator;
            FileUtils.forceMkdir((File)new File(outputdir));
            zf = new ZipFile(zipfile, "GBK");
            Enumeration zipArchiveEntrys = zf.getEntries();
            while (zipArchiveEntrys.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)zipArchiveEntrys.nextElement();
                if (zipArchiveEntry.isDirectory()) {
                    FileUtils.forceMkdir((File)new File(outputdir + zipArchiveEntry.getName() + File.separator));
                    continue;
                }
                InputStream inputStream = zf.getInputStream(zipArchiveEntry);
                FileOutputStream outputStream = FileUtils.openOutputStream((File)new File(outputdir + zipArchiveEntry.getName()));
                IOUtils.copy((InputStream)zf.getInputStream(zipArchiveEntry), (OutputStream)outputStream);
                FileUtil.close(inputStream);
                FileUtil.close(outputStream);
            }
        } else {
            throw new IOException("\u6307\u5b9a\u7684\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a\t" + zipfilename);
        }
        zf.close();
    }
}

