/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class WriteFile {
    private BufferedWriter writer;
    private FileOutputStream fos;
    private OutputStreamWriter osw;

    public WriteFile(String fileName) throws IOException {
        this.fos = new FileOutputStream(fileName);
        this.osw = new OutputStreamWriter((OutputStream)this.fos, "UTF-8");
        this.writer = new BufferedWriter(this.osw);
    }

    public WriteFile(String fileName, String charsetName) throws IOException {
        this.fos = new FileOutputStream(fileName);
        this.osw = new OutputStreamWriter((OutputStream)this.fos, charsetName);
        this.writer = new BufferedWriter(this.osw);
    }

    public void append(String content) {
        try {
            this.writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void appendLine(String content) {
        try {
            this.writer.write(content);
            this.writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void close(WriteFile writeFile) {
        if (writeFile != null) {
            writeFile.close();
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.writer = null;
            this.osw = null;
            this.fos = null;
        }
    }

    public static void main(String[] args) throws IOException {
        WriteFile writeFile = new WriteFile("D:\\data\\testwriter.txt");
        writeFile.appendLine("11111");
        writeFile.appendLine("22222");
        writeFile.close();
    }

    public void newLine() throws IOException {
        this.writer.newLine();
    }
}

