/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import com.github.niupengyu.core.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class Unicode {
    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + "\\u" + Integer.toHexString(chr1) : result + str.charAt(i);
        }
        return result;
    }

    public static String chinaToUnicode2(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u4e00' && chr1 <= '\u29fa5' ? result + Integer.toHexString(chr1) : result + str.charAt(i);
        }
        return result;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String string2Unicode2(String s) {
        try {
            StringBuffer out = new StringBuffer("");
            byte[] bytes = s.getBytes("unicode");
            for (int i = 2; i < bytes.length - 1; i += 2) {
                out.append("u");
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str);
                out.append(str1);
                out.append(" ");
            }
            return out.toString().toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String string2Unicode2(String s, String u, String k) {
        try {
            StringBuffer out = new StringBuffer("");
            byte[] bytes = s.getBytes("unicode");
            for (int i = 2; i < bytes.length - 1; i += 2) {
                out.append(u);
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str);
                out.append(str1);
                out.append(k);
            }
            return out.toString().toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String string2Unicode(String s) {
        try {
            StringBuffer out = new StringBuffer("");
            byte[] bytes = s.getBytes("unicode");
            for (int i = 2; i < bytes.length - 1; i += 2) {
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str);
                out.append(str1);
            }
            return out.toString().toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String unicode2String(String unicodeStr) throws Exception {
        StringBuffer sb = new StringBuffer();
        String[] str = unicodeStr.toUpperCase().split("U");
        for (int i = 0; i < str.length; ++i) {
            if (str[i].equals("")) continue;
            char c = (char)Integer.parseInt(str[i].trim(), 16);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unicode2String2(String unicodeStr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < unicodeStr.length(); i += 4) {
            String str = unicodeStr.substring(i, i + 4);
            char c = (char)Integer.parseInt(str.trim(), 16);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String convert(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            sb.append("\\u");
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String revert(String str) {
        String string = str = str == null ? "" : str;
        if (str.indexOf("\\u") == -1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(1000);
        for (int i = 0; i < str.length() - 6; i += 6) {
            String strTemp = str.substring(i, i + 6);
            String value = strTemp.substring(2);
            int c = 0;
            for (int j = 0; j < value.length(); ++j) {
                char tempChar = value.charAt(j);
                int t = 0;
                switch (tempChar) {
                    case 'a': {
                        t = 10;
                        break;
                    }
                    case 'b': {
                        t = 11;
                        break;
                    }
                    case 'c': {
                        t = 12;
                        break;
                    }
                    case 'd': {
                        t = 13;
                        break;
                    }
                    case 'e': {
                        t = 14;
                        break;
                    }
                    case 'f': {
                        t = 15;
                        break;
                    }
                    default: {
                        t = tempChar - 48;
                    }
                }
                c += t * (int)Math.pow(16.0, value.length() - j - 1);
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String convert1(String str) {
        str = str == null ? "" : str;
        StringBuffer sb = new StringBuffer(1000);
        sb.setLength(0);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int j = c >>> 8;
            String tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
            j = c & 0xFF;
            tmp = Integer.toHexString(j);
            if (tmp.length() == 1) {
                sb.append("0");
            }
            sb.append(tmp);
        }
        return new String(sb);
    }

    public static String revert1(String str) {
        String string = str = str == null ? "" : str;
        if (StringUtil.isNull(str)) {
            return str;
        }
        StringBuffer sb = new StringBuffer(1000);
        for (int i = 0; i < str.length(); i += 4) {
            String strTemp;
            String value = strTemp = str.substring(i, i + 4);
            int c = 0;
            for (int j = 0; j < value.length(); ++j) {
                char tempChar = value.charAt(j);
                int t = 0;
                switch (tempChar) {
                    case 'a': {
                        t = 10;
                        break;
                    }
                    case 'b': {
                        t = 11;
                        break;
                    }
                    case 'c': {
                        t = 12;
                        break;
                    }
                    case 'd': {
                        t = 13;
                        break;
                    }
                    case 'e': {
                        t = 14;
                        break;
                    }
                    case 'f': {
                        t = 15;
                        break;
                    }
                    default: {
                        t = tempChar - 48;
                    }
                }
                c += t * (int)Math.pow(16.0, value.length() - j - 1);
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Unicode.unicode2String("asdf");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

