/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ThreadLocalDateUtil {
    private static final String[] date_format = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "dd"};
    private static ThreadLocal<DateFormat[]> threadLocal = new ThreadLocal();

    private ThreadLocalDateUtil() {
    }

    public static DateFormat getDateFormat(int i) {
        DateFormat[] df = threadLocal.get();
        if (df == null) {
            df = new DateFormat[]{new SimpleDateFormat(date_format[0]), new SimpleDateFormat(date_format[1]), new SimpleDateFormat(date_format[2])};
            threadLocal.set(df);
        }
        return df[i];
    }

    public static String getDateString(Date date, int hour, int min, int sec, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return ThreadLocalDateUtil.getDateFormat(i).format(cal.getTime());
    }

    public static Date getDate(Date date, int hour, int min, int sec) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        return cal.getTime();
    }

    public static Date getDate(int year, int month, int day, int hour, int min, int sec, int mi) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, mi);
        return cal.getTime();
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return ThreadLocalDateUtil.getDateFormat(0).format(date);
    }

    public static String formatDate(Object obj) {
        if (obj instanceof Date) {
            return ThreadLocalDateUtil.getDateFormat(0).format(obj);
        }
        return "";
    }

    public static String formatDate(Object obj, int i) {
        if (obj instanceof Date) {
            return ThreadLocalDateUtil.getDateFormat(i).format(obj);
        }
        return "";
    }

    public static String formatDateTime(Date date) {
        return ThreadLocalDateUtil.getDateFormat(1).format(date);
    }

    public static String formatDateTime(Object obj) {
        if (obj instanceof Date) {
            return ThreadLocalDateUtil.getDateFormat(1).format(obj);
        }
        return "";
    }

    public static String formatDate(Date date, int i) {
        return ThreadLocalDateUtil.getDateFormat(i).format(date);
    }

    public static Date parse(String strDate, int i) {
        try {
            return ThreadLocalDateUtil.getDateFormat(i).parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getNextDay(int i, int j) throws ParseException {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        date = calendar.getTime();
        return ThreadLocalDateUtil.formatDate(date, j);
    }

    public static String getNextDay(Date date, int i, int j) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        date = calendar.getTime();
        return ThreadLocalDateUtil.formatDate(date, j);
    }

    public static Date getNextDate(Date date, int i) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        date = calendar.getTime();
        return date;
    }

    public static Date getNextDate(int i) throws ParseException {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, i);
        date = calendar.getTime();
        return date;
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public static boolean isNull(Object str) {
        return str == null || ThreadLocalDateUtil.isNull(str.toString());
    }

    public static String strvalueOf(String str) {
        if (ThreadLocalDateUtil.isNull(str)) {
            return "";
        }
        return str;
    }

    public static String intvalueOf(String str) {
        if (ThreadLocalDateUtil.isNull(str)) {
            return "0";
        }
        return str;
    }

    public static String getTimeDes(long ms) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        long milliSecond = ms - day * (long)dd - hour * (long)hh - minute * (long)mi - second * (long)ss;
        StringBuilder str = new StringBuilder();
        if (day > 36500L) {
            str.append(day / 36500L).append("\u4e16\u7eaa");
        } else if (day > 365L) {
            str.append(day / 365L).append("\u5e74");
        } else if (day > 0L) {
            str.append(day).append("\u5929");
        } else if (hour > 0L) {
            str.append(hour).append("\u5c0f\u65f6");
        } else if (minute > 0L) {
            str.append(minute).append("\u5206\u949f");
        } else if (second > 0L) {
            str.append(second).append("\u79d2");
        } else if (milliSecond > 0L) {
            str.append(1).append("\u79d2");
        }
        return str.toString();
    }

    public static Date lastFirday() {
        Calendar calendar = Calendar.getInstance();
        while (calendar.get(7) != 2) {
            calendar.add(7, -1);
        }
        int dayOfWeek = calendar.get(7) - 1;
        int offset = 7 - dayOfWeek;
        calendar.add(5, offset - 9);
        return ThreadLocalDateUtil.getFirstDayOfWeek(calendar.getTime(), 6);
    }

    public static Date lastMonday() {
        Calendar calendar = Calendar.getInstance();
        while (calendar.get(7) != 2) {
            calendar.add(7, -1);
        }
        int dayOfWeek = calendar.get(7) - 1;
        int offset = 1 - dayOfWeek;
        calendar.add(5, offset - 7);
        return ThreadLocalDateUtil.getFirstDayOfWeek(calendar.getTime(), 2);
    }

    public static Date getFirstDayOfWeek(Date date, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.set(7, firstDayOfWeek);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

