/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String reg = "\\[.*\\d+.*\\]";

    public static boolean isNull(Object obj) {
        boolean flag = false;
        if (obj == null || "".equals(obj)) {
            flag = true;
        }
        return flag;
    }

    public static boolean notNull(Object obj) {
        boolean flag = false;
        if (obj != null && !"".equals(obj)) {
            flag = true;
        }
        return flag;
    }

    public static boolean setIsNull(Set<?> mains) {
        if (StringUtil.isNull(mains)) {
            return true;
        }
        return mains.size() < 1 || mains.isEmpty();
    }

    public static boolean mapIsNull(Map<?, ?> mapSet) {
        return StringUtil.isNull(mapSet) || mapSet.size() < 1 || mapSet.isEmpty();
    }

    public static <T> T mapValue(Map<?, ?> mapSet, String key) {
        if (mapSet != null && mapSet.containsKey(key)) {
            return (T)mapSet.get(key);
        }
        return null;
    }

    public static boolean listIsNull(List<?> mains) {
        if (StringUtil.isNull(mains)) {
            return true;
        }
        return mains.size() < 1 || mains.isEmpty();
    }

    public static boolean arrNotNull(Object[] mains) {
        return mains != null && mains.length > 0;
    }

    public static boolean isNull(String[] strs) {
        return strs == null || strs.length < 1;
    }

    public static String[] split(String str) {
        String[] strs = str.split(" ");
        ArrayList<String> sets = new ArrayList<String>();
        for (String s : strs) {
            if (" ".equals(s)) continue;
            sets.add(s);
        }
        return sets.toArray(new String[sets.size()]);
    }

    public static boolean mapNotNull(Map map) {
        return map != null && !map.isEmpty();
    }

    public static boolean hasText(String text) {
        return !StringUtil.isNull(text.trim());
    }

    public static String valueOf(String value) {
        return StringUtil.isNull(value) ? "" : value;
    }

    public static String valueOf(Integer value) {
        return StringUtil.isNull(value) ? "" : String.valueOf(value);
    }

    public static String valueOf(Object value) {
        return StringUtil.isNull(value) ? "" : String.valueOf(value);
    }

    public static boolean matchArr(String key) {
        Pattern pattern = Pattern.compile(reg);
        Matcher isNum = pattern.matcher(key);
        return isNum.matches();
    }

    public static <T> T valueOf(String value, String defaults, Class<T> type) {
        if (StringUtil.isNull(value)) {
            return type.cast(defaults);
        }
        return type.cast(value);
    }

    public static String valueOf(String value, String defaults) {
        if (StringUtil.isNull(value)) {
            return StringUtil.valueOf(defaults);
        }
        return StringUtil.valueOf(value);
    }

    public static <T> T valueOf(T ... values) {
        for (T value : values) {
            if (!StringUtil.notNull(value)) continue;
            return value;
        }
        return null;
    }

    public static String valueOf(Object value, String defaults) {
        if (StringUtil.isNull(value)) {
            return StringUtil.valueOf(defaults);
        }
        return StringUtil.valueOf(value);
    }

    public static Integer integerValueOf(Integer value, Integer defaults) {
        if (value == null) {
            return defaults;
        }
        return value;
    }

    public static Integer integerValueOf(String value, Integer defaults) {
        if (StringUtil.isNull(value)) {
            return defaults;
        }
        return Integer.parseInt(value);
    }

    public static Double doubleValueOf(Double value, Double defaults) {
        if (value == null) {
            return defaults;
        }
        return value;
    }

    public static Double doubleValueOf(String value, Double defaults) {
        if (StringUtil.isNull(value)) {
            return defaults;
        }
        return Double.parseDouble(value);
    }

    public static Integer integerValueOf(Integer value, Integer value1, Integer defaults) {
        if (value != null) {
            return value;
        }
        if (value1 != null) {
            return value1;
        }
        return defaults;
    }

    public static Long longValueOf(Long value, Long defaults) {
        if (value == null) {
            return defaults;
        }
        return value;
    }

    public static Long longValueOf(Long value, Long value1, Long defaults) {
        if (value != null) {
            return value;
        }
        if (value1 != null) {
            return value1;
        }
        return defaults;
    }

    public static Boolean booleanValueOf(Boolean value, Boolean defaults) {
        if (value == null) {
            return defaults;
        }
        return value;
    }

    public static Boolean booleanValueOf(String value, boolean defaults) {
        if (StringUtil.isNull(value)) {
            return defaults;
        }
        return Boolean.valueOf(value);
    }

    public static Boolean booleanValueOf(Object value, Boolean defaults) {
        if (value == null) {
            return defaults;
        }
        return (Boolean)Boolean.class.cast(value);
    }

    public static Boolean booleanValueOf(Boolean value, Boolean value1, Boolean defaults) {
        if (value != null) {
            return value;
        }
        if (value1 != null) {
            return value1;
        }
        return defaults;
    }

    public static String subString(String str, int length) {
        int strLength = str.length();
        if (strLength > length) {
            return str.substring(0, length);
        }
        return str;
    }

    public static String[] valueOf(String[] mappersXml, String[] mappersXml1) {
        if (StringUtil.arrNotNull(mappersXml)) {
            return mappersXml;
        }
        return mappersXml;
    }

    public static List<String> valueOf(List<String> mappers, List<String> mappers1) {
        if (StringUtil.listIsNull(mappers)) {
            return mappers1;
        }
        return mappers;
    }

    public static Map<String, Object> mapValueOf(Map<String, Object> prop, Map<String, Object> prop1) {
        if (prop == null || prop.isEmpty()) {
            return prop;
        }
        return prop1;
    }

    public static String append(Object ... strings) {
        StringBuilder sb = new StringBuilder();
        for (Object s : strings) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(int num, String str, String sep) {
        StringBuilder sb = new StringBuilder();
        int size = num - 1;
        for (int i = 0; i < size; ++i) {
            sb.append(str).append(sep);
        }
        sb.append(str);
        return sb.toString();
    }
}

