/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.callback.ReadCallBack;
import com.github.niupengyu.core.util.callback.ReadCallBacks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ReadFile {
    private int size;
    private File file;
    private int total;
    private String charSet;

    public ReadFile(String path) {
        this.file = new File(path);
        this.charSet = "UTF-8";
    }

    public ReadFile(String path, int size, int total) {
        this.size = size;
        this.file = new File(path);
        this.total = total;
        this.charSet = "UTF-8";
    }

    public ReadFile(String path, String charSet) {
        this.file = new File(path);
        this.charSet = charSet;
    }

    public ReadFile(String path, int size, int total, String charSet) {
        this.size = size;
        this.file = new File(path);
        this.total = total;
        this.charSet = charSet;
    }

    public ReadFile(File file) {
        this.file = file;
        this.charSet = "UTF-8";
    }

    public ReadFile(File file, int size, int total) {
        this.size = size;
        this.file = file;
        this.total = total;
        this.charSet = "UTF-8";
    }

    public ReadFile(File file, String charSet) {
        this.file = file;
        this.charSet = charSet;
    }

    public ReadFile(File file, int size, int total, String charSet) {
        this.size = size;
        this.file = file;
        this.total = total;
        this.charSet = charSet;
    }

    public void read(ReadCallBack readCallBack) {
        try (FileInputStream fin = new FileInputStream(this.file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, this.charSet);
             BufferedReader out = new BufferedReader(inr);){
            String str = null;
            while ((str = out.readLine()) != null) {
                readCallBack.call(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(ReadCallBack readCallBack, int max) {
        int count = 0;
        try (FileInputStream fin = new FileInputStream(this.file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, this.charSet);
             BufferedReader out = new BufferedReader(inr);){
            String str = null;
            while ((str = out.readLine()) != null) {
                readCallBack.call(str);
                if (count > max) {
                    break;
                }
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(String path) {
        File file = new File(path);
        String str = null;
        try (FileInputStream fin = new FileInputStream(file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, "UTF-8");
             BufferedReader out = new BufferedReader(inr);){
            str = out.readLine();
            if (str != null) return str;
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file) {
        String str = null;
        try (FileInputStream fin = new FileInputStream(file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, "UTF-8");
             BufferedReader out = new BufferedReader(inr);){
            str = out.readLine();
            if (str != null) return str;
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(String path, String charSet) {
        File file = new File(path);
        String str = null;
        try (FileInputStream fin = new FileInputStream(file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, charSet);
             BufferedReader out = new BufferedReader(inr);){
            str = out.readLine();
            if (str != null) return str;
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file, String charSet) {
        String str = null;
        try (FileInputStream fin = new FileInputStream(file);
             InputStreamReader inr = new InputStreamReader((InputStream)fin, charSet);
             BufferedReader out = new BufferedReader(inr);){
            str = out.readLine();
            if (str != null) return str;
            String string = "";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }

    public void reads(ReadCallBacks readCallBacks) {
        try (BufferedReader out = new BufferedReader(new FileReader(this.file));){
            String str = null;
            int i = 0;
            ArrayList<String> strs = new ArrayList<String>();
            for (int index = 0; index < this.total && (str = out.readLine()) != null; ++index) {
                if (i == this.size) {
                    readCallBacks.call(strs);
                    strs = new ArrayList();
                    i = 0;
                }
                strs.add(str);
                ++i;
            }
            if (strs.size() > 0) {
                readCallBacks.call(strs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int total = 10;
        int thread = 4;
        String path = "D:\\data\\sd_out_1w.csv";
        int size = PageUtil.maxPage(thread, total);
        ReadFile readFile = new ReadFile(path, size, total);
        long start = System.currentTimeMillis();
        readFile.reads(new ReadCallBacks(){

            @Override
            public void call(List<String> strs) {
                System.out.println(strs);
                System.out.println(strs.size());
            }
        });
    }
}

