/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

public class PageUtil {
    private int start;
    private int size;
    private int maxPage;
    private int total;
    private int page;

    public PageUtil(int page, int size, int total) {
        this.page = page;
        this.size = size;
        this.total = total;
        this.maxPage = total % size == 0 ? total / size : total / size + 1;
        this.start = (page - 1) * size;
    }

    public PageUtil(int page, int size) {
        this.page = page;
        this.size = size;
        this.maxPage = this.total % size == 0 ? this.total / size : this.total / size + 1;
        this.start = (page - 1) * size;
    }

    public int getStart() {
        return this.start;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public int getTotal() {
        return this.total;
    }

    public int getPage() {
        return this.page;
    }

    public static int maxPage(int size, int total) {
        return total % size == 0 ? total / size : total / size + 1;
    }

    public static int start(int page, int size) {
        return (page - 1) * size;
    }

    public static int oracleStart(int page, int size) {
        return (page - 1) * size;
    }

    public static int oracleEnd(int page, int size) {
        return page * size;
    }

    public static void main(String[] args) {
        PageUtil pageUtil = new PageUtil(1, 20, 100);
        pageUtil.getStart();
        pageUtil.getMaxPage();
    }
}

