/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ObjUtil
implements Cloneable {
    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static String toStr(Object obj, String defultVal) {
        if (obj != null) {
            return String.valueOf(obj);
        }
        return defultVal;
    }

    public static String toStr(Object obj) {
        return ObjUtil.toStr(obj, "");
    }

    public static int toInt(Object value, int defaultValue) {
        int val = defaultValue;
        try {
            val = Integer.parseInt(ObjUtil.toStr(value, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static int toInt(Object value) {
        return ObjUtil.toInt(value, 0);
    }

    public static long toLong(Object value, long defaultValue) {
        long val = defaultValue;
        try {
            val = Long.parseLong(ObjUtil.toStr(value, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static boolean toBoolean(Object value) {
        return ObjUtil.toBoolean(value, false);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        boolean val = defaultValue;
        try {
            val = Boolean.parseBoolean(ObjUtil.toStr(value, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static long toLong(Object value) {
        return ObjUtil.toLong(value, 0L);
    }

    public static Double toDouble(Object value, Double defaultValue) {
        Double val = defaultValue;
        try {
            val = Double.valueOf(ObjUtil.toStr(value, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static Double toDouble(Object value) {
        return ObjUtil.toDouble(value, 0.0);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        BigDecimal val = defaultValue;
        try {
            val = new BigDecimal(ObjUtil.toStr(value, ""));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static BigDecimal toBigDecimal(Object value) {
        return ObjUtil.toBigDecimal(value, new BigDecimal(0));
    }

    public static Date toDate(Object value) {
        Date retDate = null;
        String val = ObjUtil.toStr(value);
        if (StrUtil.isEmpty(val)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            retDate = sdf.parse(val);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return retDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(Object obj) {
        String serStr;
        block5: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ObjectOutputStream objectOutputStream = null;
            serStr = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(obj);
                serStr = byteArrayOutputStream.toString("ISO-8859-1");
                serStr = URLEncoder.encode(serStr, "UTF-8");
                FileUtil.close(objectOutputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                FileUtil.close(objectOutputStream);
                FileUtil.close(byteArrayOutputStream);
                objectOutputStream = null;
                byteArrayOutputStream = null;
            }
            FileUtil.close(byteArrayOutputStream);
            objectOutputStream = null;
            byteArrayOutputStream = null;
        }
        return serStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unSerialize(String serStr) {
        Object obj;
        block5: {
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            obj = null;
            try {
                String redStr = URLDecoder.decode(serStr, "UTF-8");
                byteArrayInputStream = new ByteArrayInputStream(redStr.getBytes("ISO-8859-1"));
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                obj = objectInputStream.readObject();
                FileUtil.close(objectInputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                FileUtil.close(objectInputStream);
                FileUtil.close(byteArrayInputStream);
                objectInputStream = null;
                byteArrayInputStream = null;
            }
            FileUtil.close(byteArrayInputStream);
            objectInputStream = null;
            byteArrayInputStream = null;
        }
        return obj;
    }
}

