/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtils {
    public static void main(String[] args) throws IOException {
        GZipUtils.zipFile("E:\\testzip", "E:\\testzip.zip");
        GZipUtils.unZipFile("D:\\test\\kevin.mp4.zip", "D:\\test\\kevin.mp4.zip.mp4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unGzip(byte[] buf) throws IOException {
        GZIPInputStream gzi = null;
        OutputStream bos = null;
        try {
            gzi = new GZIPInputStream(new ByteArrayInputStream(buf));
            bos = new ByteArrayOutputStream(buf.length);
            int count = 0;
            byte[] tmp = new byte[2048];
            while ((count = gzi.read(tmp)) != -1) {
                ((ByteArrayOutputStream)bos).write(tmp, 0, count);
            }
            buf = ((ByteArrayOutputStream)bos).toByteArray();
        }
        finally {
            if (bos != null) {
                bos.flush();
                ((ByteArrayOutputStream)bos).close();
            }
            if (gzi != null) {
                gzi.close();
            }
        }
        return buf;
    }

    public static byte[] gzip(byte[] val) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(val.length);
        GZIPOutputStream gos = null;
        try {
            gos = new GZIPOutputStream(bos);
            gos.write(val, 0, val.length);
            gos.finish();
            gos.flush();
            bos.flush();
            val = bos.toByteArray();
        }
        finally {
            if (gos != null) {
                gos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(String source, String target) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        DeflaterOutputStream gzout = null;
        try {
            int num;
            fin = new FileInputStream(new File(source));
            fout = new FileOutputStream(target);
            gzout = new GZIPOutputStream(fout);
            byte[] buf = new byte[1024];
            while ((num = fin.read(buf)) != -1) {
                ((GZIPOutputStream)gzout).write(buf, 0, num);
            }
        }
        finally {
            if (gzout != null) {
                gzout.close();
            }
            if (fout != null) {
                fout.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(String source, String target) throws IOException {
        FileInputStream fin = null;
        GZIPInputStream gzin = null;
        FileOutputStream fout = null;
        try {
            int num;
            fin = new FileInputStream(source);
            gzin = new GZIPInputStream(fin);
            fout = new FileOutputStream(target);
            byte[] buf = new byte[1024];
            while ((num = gzin.read(buf, 0, buf.length)) != -1) {
                fout.write(buf, 0, num);
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
            if (gzin != null) {
                gzin.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }
}

