/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.util;

import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.core.util.data.NumberUtil;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateUtil {
    public static final String FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String FIRST_TIME = " 00:00:00";
    public static final String LAST_TIME = " 23:59:59";
    public static final String FIRST_TIME1 = "00:00:00";
    public static final String LAST_TIME1 = "23:59:59";
    public static final long PERIOD_DAY = 86400000L;

    private DateUtil() {
    }

    public static long toMilli(LocalDateTime ldt) {
        return ldt.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toMilli() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public static long toSecond() {
        return LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static long toSecond(LocalDateTime ldt) {
        return ldt.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static String dateFormat(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern(FORMAT));
    }

    public static String dateFormat() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(FORMAT));
    }

    public static String dateFormatDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT));
    }

    public static String dateFormatDate(int i) {
        return LocalDate.now().minusDays(i).format(DateTimeFormatter.ofPattern(DATE_FORMAT));
    }

    public static String dateFormat(LocalDateTime dateTime, String format) {
        return dateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public static String dateFormat(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String dateFormat(LocalDate date, String format) {
        return date.format(DateTimeFormatter.ofPattern(format));
    }

    public static String dateFormat(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(DATE_FORMAT));
    }

    public static LocalDateTime getFirstTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.of(0, 0, 0));
    }

    public static LocalDateTime getEndTime() {
        return LocalDateTime.of(LocalDate.now(), LocalTime.of(23, 59, 59));
    }

    public static LocalDateTime getFirstTime(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.of(0, 0, 0));
    }

    public static LocalDate getLocalDate(int day) {
        return LocalDate.now().minusDays(day);
    }

    public static LocalDateTime getEndTime(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.of(23, 59, 59));
    }

    public static LocalDateTime getFirstTime(int day) {
        return LocalDateTime.of(LocalDate.now().minusDays(day), LocalTime.of(0, 0, 0));
    }

    public static LocalDateTime getEndTime(int day) {
        return LocalDateTime.of(LocalDate.now().minusDays(day), LocalTime.of(23, 59, 59));
    }

    public static LocalTime getFirstLocalTime() {
        return LocalTime.of(0, 0, 0);
    }

    public static LocalTime getEndLocalTime() {
        return LocalTime.of(23, 59, 59);
    }

    public static LocalDateTime getLocalDateTime(String date, String format) {
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDate getLocalDate(String date, String format) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalTime getLocalTime(String date, String format) {
        return LocalTime.parse(date, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime getLocalDateTime(String date) {
        return LocalDateTime.parse(date, DateTimeFormatter.ofPattern(FORMAT));
    }

    public static LocalDate getLocalDate(String date) {
        return LocalDate.parse(date, DateTimeFormatter.ofPattern(DATE_FORMAT));
    }

    public static LocalTime getLocalTime(String date) {
        return LocalTime.parse(date, DateTimeFormatter.ofPattern(TIME_FORMAT));
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static Date localDateTimeTodate(LocalDateTime localDateTime) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static String getTimeDes(long ms) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long temp = ms - day * (long)dd;
        long hour = temp / (long)hh;
        long hourTemp = temp - hour * (long)hh;
        long minute = hourTemp / (long)mi;
        long second = (hourTemp - minute * (long)mi) / (long)ss;
        long milliSecond = hourTemp - minute * (long)mi - second * (long)ss;
        StringBuilder str = new StringBuilder();
        if (day > 0L) {
            str.append(day).append("\u5929");
        }
        if (hour > 0L) {
            str.append(hour).append("\u5c0f\u65f6");
        }
        if (minute > 0L) {
            str.append(minute).append("\u5206\u949f");
        }
        if (second > 0L || milliSecond > 0L) {
            str.append(second).append(".");
            str.append(NumberUtil.format(milliSecond, 3)).append("\u79d2");
        }
        return str.toString();
    }

    public static LocalDateTime getLocalDateTime(long times) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(times), ZoneId.systemDefault());
    }

    public static String mysqlFormat(String date) {
        return "DATE_FORMAT(" + date + ",'%Y-%m-%d') as " + date;
    }

    public static String dateFormat(String format, Date time) {
        if (StringUtil.isNull(time)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(time);
    }

    public static String dateFormat(Date time) {
        if (StringUtil.isNull(time)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT);
        return simpleDateFormat.format(time);
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getTimeDes(163238345L));
    }
}

