/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.message;

import com.github.niupengyu.core.exception.SysException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(MessageManager.class);
    final Lock lock = new ReentrantLock();
    private List<T> message = new ArrayList<T>();
    private String name;

    public MessageManager(String name) {
        this.name = name;
    }

    public void add(T messageobj) throws SysException {
        this.lock.lock();
        try {
            this.message.add(messageobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T getMessage() {
        this.lock.lock();
        T obj = null;
        try {
            if (this.message.size() > 0) {
                obj = this.message.get(0);
                this.message.remove(0);
                logger.info(this.name + " \u5269\u4f59\u6d88\u606f ----->[" + this.message.size() + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return obj;
    }

    public int messageSize() {
        this.lock.lock();
        int size = 0;
        try {
            size = this.message.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return size;
    }
}

