/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.message;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheMap<K, V>
extends AbstractMap<K, V> {
    private long DEFAULT_TIMEOUT = 30000L;
    private long cacheTimeout;
    private Map<K, CacheEntry> map = new HashMap<K, CacheEntry>();

    public CacheMap(long timeout) {
        this.cacheTimeout = timeout;
        new ClearThread().start();
    }

    public CacheMap() {
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<K, CacheEntry>> wrapEntrySet = this.map.entrySet();
        for (Map.Entry<K, CacheEntry> entry : wrapEntrySet) {
            entrySet.add(entry.getValue());
        }
        return entrySet;
    }

    @Override
    public V get(Object key) {
        CacheEntry entry = this.map.get(key);
        return entry == null ? null : (V)entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        CacheEntry entry = new CacheEntry(key, value);
        Map<K, CacheEntry> map = this.map;
        synchronized (map) {
            this.map.put(key, entry);
        }
        return value;
    }

    private class ClearThread
    extends Thread {
        ClearThread() {
            this.setName("clear cache thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object[] keys;
                        long now = System.currentTimeMillis();
                        for (Object key : keys = CacheMap.this.map.keySet().toArray()) {
                            CacheEntry entry = (CacheEntry)CacheMap.this.map.get(key);
                            if (now - entry.time < CacheMap.this.cacheTimeout) continue;
                            Map map = CacheMap.this.map;
                            synchronized (map) {
                                CacheMap.this.map.remove(key);
                            }
                        }
                        Thread.sleep(CacheMap.this.cacheTimeout);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class CacheEntry
    implements Map.Entry<K, V> {
        long time;
        V value;
        K key;

        CacheEntry(K key, V value) {
            this.value = value;
            this.key = key;
            this.time = System.currentTimeMillis();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return this.value;
        }
    }
}

