/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.init;

import com.github.niupengyu.core.util.FileUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BaseSysinitBean
extends ApplicationObjectSupport
implements InitializingBean {
    private static ApplicationContext ac1;
    @Autowired
    private Environment environment;

    public void afterPropertiesSet() throws Exception {
        ac1 = this.getApplicationContext();
    }

    public static <T> T getBean(String beanName) {
        Object t = ac1.getBean(beanName);
        return (T)(t == null ? null : t);
    }

    public static <T> T getBean(Class<T> className) {
        return (T)ac1.getBean(className);
    }

    public static String getValue(String key) {
        Environment environment = (Environment)ac1.getBean(Environment.class);
        return environment.getProperty(key);
    }

    public static String getValue(String key, String dev) {
        Environment environment = (Environment)ac1.getBean(Environment.class);
        return environment.getProperty(key, dev);
    }

    public static <T> T getValue(String key, Class<T> clazz) {
        Environment environment = (Environment)ac1.getBean(Environment.class);
        return (T)environment.getProperty(key, clazz);
    }

    public static <T> T getValue(String key, Class<T> clazz, T defaultV) {
        Environment environment = (Environment)ac1.getBean(Environment.class);
        return (T)environment.getProperty(key, clazz, defaultV);
    }

    public static String diskFilePath(String subPath) {
        String diskPath = BaseSysinitBean.getValue("news.file-config.diskPath");
        String path = diskPath + '/' + subPath;
        return FileUtil.mkdirs(path);
    }

    public static String diskFilePath() {
        String diskPath = BaseSysinitBean.getValue("news.file-config.diskPath");
        FileUtil.mkdirs1(diskPath);
        return diskPath;
    }

    public static ApplicationContext getAc1() {
        return ac1;
    }
}

