/*
 * Decompiled with CFR 0.152.
 */
package com.github.niupengyu.core.factory;

import com.github.niupengyu.core.annotation.AutoConfig;
import com.github.niupengyu.core.annotation.ScheduleService;
import com.github.niupengyu.core.bean.FactoryConfig;
import com.github.niupengyu.core.util.ClassUtil;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;

@Configuration
@AutoConfig(name="news.bean-factory.enable")
public class AheadBeanFactory
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware {
    private Logger logger = LoggerFactory.getLogger(AheadBeanFactory.class);
    private FactoryConfig factoryConfig;

    public void setEnvironment(Environment environment) {
        Binder binder = Binder.get((Environment)environment);
        BindResult bindResult = binder.bind("news.bean-factory", Bindable.of(FactoryConfig.class));
        if (bindResult.isBound()) {
            this.factoryConfig = (FactoryConfig)bindResult.get();
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Object[] packs = this.factoryConfig.getClassPackages();
        System.out.println(Arrays.toString(packs));
        for (Object pack : packs) {
            System.out.println((String)pack);
            Set<Class<?>> classSet = ClassUtil.getClasses((String)pack);
            System.out.println(classSet);
            for (Class<?> set : classSet) {
                System.out.println(set);
                String name = set.getName();
                System.out.println(name);
                BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(set);
                Service service = set.getAnnotation(Service.class);
                Repository repository = set.getAnnotation(Repository.class);
                Component component = set.getAnnotation(Component.class);
                if (service != null) {
                    beanDefinitionRegistry.registerBeanDefinition(service.value(), (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
                    this.logger.info("registry service class " + name);
                }
                if (component != null) {
                    beanDefinitionRegistry.registerBeanDefinition(component.value(), (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
                    this.logger.info("registry component class " + name);
                }
                if (repository != null) {
                    beanDefinitionRegistry.registerBeanDefinition(repository.value(), (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
                    this.logger.info("registry repository class " + name);
                    continue;
                }
                ScheduleService scheduleService = set.getAnnotation(ScheduleService.class);
                if (scheduleService != null && scheduleService.registry()) {
                    this.logger.info("registry class " + name);
                    beanDefinitionRegistry.registerBeanDefinition(scheduleService.value(), (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
                    continue;
                }
                this.logger.info("skip class " + name);
            }
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        this.logger.info("postProcessBeanFactory...");
    }
}

