/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagString
extends NBTTag {
    private String value;

    public NBTTagString(String value) {
        if (value.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("String to long");
        }
        this.value = value;
    }

    NBTTagString() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("String to long");
        }
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeShort(this.value.length());
        out.write(this.value.getBytes());
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        short length = in.readShort();
        byte[] bytes = new byte[length];
        in.read(bytes);
        this.value = new String(bytes);
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.STRING;
    }

    public String toString() {
        return this.value;
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.STRING) && tag.getAsTagString().getValue().equals(this.value);
    }
}

