/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagShort
extends NBTTag {
    private short value;

    public NBTTagShort(short value) {
        this.value = value;
    }

    NBTTagShort() {
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = in.readShort();
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.SHORT;
    }

    public String toString() {
        return String.valueOf(this.value) + "s";
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.SHORT) && tag.getAsTagShort().getValue() == this.value;
    }
}

