/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagLongArray
extends NBTTag {
    private long[] value;

    public NBTTagLongArray(long[] value) {
        this.value = value;
    }

    NBTTagLongArray() {
    }

    public long[] getValue() {
        return this.value;
    }

    public void setValue(long[] value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        for (long l : this.value) {
            out.writeLong(l);
        }
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = new long[in.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = in.readLong();
        }
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.LONG_ARRAY;
    }

    public String toString() {
        String out = "[L;";
        for (long i : this.value) {
            out = out + String.valueOf(i) + ", ";
        }
        out = out.substring(0, out.length() - 2);
        out = out + "]";
        return out;
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.LONG_ARRAY) && Arrays.equals(tag.getAsTagLongArray().getValue(), this.value);
    }
}

