/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagLong
extends NBTTag {
    private long value;

    public NBTTagLong(long value) {
        this.value = value;
    }

    NBTTagLong() {
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = in.readLong();
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.LONG;
    }

    public String toString() {
        return String.valueOf(this.value) + "l";
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.LONG) && tag.getAsTagLong().getValue() == this.value;
    }
}

