/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagList
extends NBTTag {
    private List<NBTTag> value;
    private TagType typeId;

    public NBTTagList(List<NBTTag> value, TagType typeId) {
        this.value = new ArrayList<NBTTag>();
        if (value != null) {
            for (NBTTag tag : value) {
                this.value.add(tag);
            }
        }
        this.typeId = typeId;
    }

    public NBTTagList(TagType typeId) {
        this.value = new ArrayList<NBTTag>();
        this.typeId = typeId;
    }

    public NBTTagList(List<NBTTag> value) {
        this.value = value;
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Cannot get tag type of list");
        }
        this.typeId = value.get(0).getTagType();
    }

    NBTTagList() {
    }

    public List<NBTTag> getValue() {
        return this.value;
    }

    public NBTTag get(int index) {
        return this.value.get(index);
    }

    public TagType getTypeId() {
        return this.typeId;
    }

    public void setValue(List<NBTTag> value) {
        this.value = value;
    }

    public NBTTagList setTypeId(TagType typeId) {
        this.typeId = typeId;
        return this;
    }

    public NBTTagList add(NBTTag tag) {
        if (tag.getTagType() != this.typeId) {
            throw new IllegalArgumentException(tag.getClass().getName() + " is not the type " + (Object)((Object)this.typeId));
        }
        this.value.add(tag);
        return this;
    }

    public NBTTagList add(int index, NBTTag tag) {
        if (tag.getTagType() != this.typeId) {
            throw new IllegalArgumentException(tag.getClass().getName() + " is not the type " + (Object)((Object)this.typeId));
        }
        this.value.add(index, tag);
        return this;
    }

    public NBTTagList remove(int index) {
        this.value.remove(index);
        return this;
    }

    public NBTTagList set(int index, NBTTag tag) {
        if (this.typeId.equals((Object)TagType.END)) {
            this.typeId = tag.getTagType();
        }
        if (tag.getTagType() != this.typeId) {
            throw new IllegalArgumentException(tag.getClass().getName() + " is not the type " + (Object)((Object)this.typeId));
        }
        this.value.set(index, tag);
        return this;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeByte(this.typeId.getId());
        out.writeInt(this.value.size());
        for (NBTTag t : this.value) {
            t.writePayloadBytes(out);
        }
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = new ArrayList<NBTTag>();
        byte id = in.readByte();
        int length = in.readInt();
        this.typeId = TagType.getTypeById(id);
        this.value = new ArrayList<NBTTag>();
        for (int i = 0; i < length; ++i) {
            this.value.add(NBTTag.newTagByType(this.typeId, in));
        }
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.LIST;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.LIST) && tag.getAsTagList().getValue().equals(this.value);
    }
}

