/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagIntArray
extends NBTTag {
    private int[] value;

    public NBTTagIntArray(int[] value) {
        this.value = value;
    }

    NBTTagIntArray() {
    }

    public int[] getValue() {
        return this.value;
    }

    public void setValue(int[] value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        for (int i : this.value) {
            out.writeInt(i);
        }
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = new int[in.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = in.readInt();
        }
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.INT_ARRAY;
    }

    public String toString() {
        String out = "[I;";
        for (int i : this.value) {
            out = out + String.valueOf(i) + ", ";
        }
        out = out.substring(0, out.length() - 2);
        out = out + "]";
        return out;
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.INT_ARRAY) && Arrays.equals(tag.getAsTagIntArray().getValue(), this.value);
    }
}

