/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagFloat
extends NBTTag {
    private float value;

    public NBTTagFloat(float value) {
        this.value = value;
    }

    NBTTagFloat() {
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeFloat(this.value);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = in.readFloat();
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.FLOAT;
    }

    public String toString() {
        return String.valueOf(this.value) + "f";
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.FLOAT) && tag.getAsTagFloat().getValue() == this.value;
    }
}

