/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagDouble
extends NBTTag {
    private double value;

    public NBTTagDouble(double value) {
        this.value = value;
    }

    NBTTagDouble() {
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeDouble(this.value);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = in.readDouble();
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.DOUBLE;
    }

    public String toString() {
        return String.valueOf(this.value) + "d";
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.DOUBLE) && tag.getAsTagDouble().getValue() == this.value;
    }
}

