/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;
import mryurihi.tbnbt.tag.NBTTagString;

public class NBTTagCompound
extends NBTTag {
    private Map<String, NBTTag> value;

    public NBTTagCompound(Map<String, NBTTag> value) {
        this.value = new HashMap<String, NBTTag>();
        if (value != null) {
            for (Map.Entry<String, NBTTag> entry : value.entrySet()) {
                NBTTag tag = entry.getValue();
                this.value.put(entry.getKey(), tag);
            }
        }
    }

    NBTTagCompound() {
    }

    public Map<String, NBTTag> getValue() {
        return this.value;
    }

    public NBTTag get(String key) {
        return this.value.get(key);
    }

    public NBTTagCompound setValue(Map<String, NBTTag> value) {
        HashMap<String, NBTTag> aux = new HashMap<String, NBTTag>();
        value.forEach((k, v) -> aux.put((String)k, (NBTTag)v));
        this.value = aux;
        return this;
    }

    public NBTTagCompound put(String key, NBTTag value) {
        this.value.put(key, value);
        return this;
    }

    public NBTTagCompound remove(String key) {
        this.value.remove(key);
        return this;
    }

    public boolean containsKey(String key) {
        return this.value.containsKey(key);
    }

    public boolean containsValue(NBTTag value) {
        return this.value.containsValue(value);
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        for (Map.Entry<String, NBTTag> entry : this.value.entrySet()) {
            out.writeByte((byte)entry.getValue().getTagType().getId());
            new NBTTagString(entry.getKey()).writePayloadBytes(out);
            entry.getValue().writePayloadBytes(out);
        }
        out.writeByte(0);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = new HashMap<String, NBTTag>();
        byte type = in.readByte();
        while (type != 0) {
            this.value.put(new NBTTagString().readPayloadBytes(in).getAsTagString().getValue(), NBTTag.newTagByType(TagType.getTypeById(type), in));
            type = in.readByte();
        }
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.COMPOUND;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.COMPOUND) && tag.getAsTagCompound().getValue().equals(this.value);
    }
}

