/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagByteArray
extends NBTTag {
    private byte[] value;

    public NBTTagByteArray(byte[] value) {
        this.value = value;
    }

    NBTTagByteArray() {
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        for (byte b : this.value) {
            out.writeByte(b);
        }
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = new byte[in.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = in.readByte();
        }
        return this;
    }

    @Override
    public TagType getTagType() {
        return TagType.BYTE_ARRAY;
    }

    public String toString() {
        String out = "[B;";
        for (byte b : this.value) {
            out = out + String.valueOf(b) + ", ";
        }
        out = out.substring(0, out.length() - 2);
        out = out + "]";
        return out;
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.BYTE_ARRAY) && Arrays.equals(tag.getAsTagByteArray().getValue(), this.value);
    }
}

