/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTag;

public class NBTTagByte
extends NBTTag {
    private byte value;

    public NBTTagByte(byte value) {
        this.value = value;
    }

    NBTTagByte() {
    }

    public byte getValue() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    @Override
    public TagType getTagType() {
        return TagType.BYTE;
    }

    public String toString() {
        return String.valueOf(this.value) + "b";
    }

    @Override
    public void writePayloadBytes(DataOutputStream out) throws IOException {
        out.writeByte(this.value);
    }

    @Override
    public NBTTag readPayloadBytes(DataInputStream in) throws IOException {
        this.value = in.readByte();
        return this;
    }

    @Override
    protected boolean equalsTag(NBTTag tag) {
        return tag.getTagType().equals((Object)TagType.BYTE) && tag.getAsTagByte().getValue() == this.value;
    }
}

