/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.tag;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.tag.NBTTagByte;
import mryurihi.tbnbt.tag.NBTTagByteArray;
import mryurihi.tbnbt.tag.NBTTagCompound;
import mryurihi.tbnbt.tag.NBTTagDouble;
import mryurihi.tbnbt.tag.NBTTagFloat;
import mryurihi.tbnbt.tag.NBTTagInt;
import mryurihi.tbnbt.tag.NBTTagIntArray;
import mryurihi.tbnbt.tag.NBTTagList;
import mryurihi.tbnbt.tag.NBTTagLong;
import mryurihi.tbnbt.tag.NBTTagLongArray;
import mryurihi.tbnbt.tag.NBTTagShort;
import mryurihi.tbnbt.tag.NBTTagString;

public abstract class NBTTag {
    public abstract void writePayloadBytes(DataOutputStream var1) throws IOException;

    public abstract NBTTag readPayloadBytes(DataInputStream var1) throws IOException;

    public abstract TagType getTagType();

    public boolean equals(Object other) {
        if (other instanceof NBTTag) {
            NBTTag tag = (NBTTag)other;
            return this.equalsTag(tag);
        }
        return false;
    }

    protected abstract boolean equalsTag(NBTTag var1);

    public NBTTagByte getAsTagByte() {
        return (NBTTagByte)NBTTagByte.class.cast(this);
    }

    public NBTTagShort getAsTagShort() {
        return (NBTTagShort)NBTTagShort.class.cast(this);
    }

    public NBTTagInt getAsTagInt() {
        return (NBTTagInt)NBTTagInt.class.cast(this);
    }

    public NBTTagLong getAsTagLong() {
        return (NBTTagLong)NBTTagLong.class.cast(this);
    }

    public NBTTagFloat getAsTagFloat() {
        return (NBTTagFloat)NBTTagFloat.class.cast(this);
    }

    public NBTTagDouble getAsTagDouble() {
        return (NBTTagDouble)NBTTagDouble.class.cast(this);
    }

    public NBTTagByteArray getAsTagByteArray() {
        return (NBTTagByteArray)NBTTagByteArray.class.cast(this);
    }

    public NBTTagString getAsTagString() {
        return (NBTTagString)NBTTagString.class.cast(this);
    }

    public NBTTagList getAsTagList() {
        return (NBTTagList)NBTTagList.class.cast(this);
    }

    public NBTTagCompound getAsTagCompound() {
        return (NBTTagCompound)NBTTagCompound.class.cast(this);
    }

    public NBTTagIntArray getAsTagIntArray() {
        return (NBTTagIntArray)NBTTagIntArray.class.cast(this);
    }

    public NBTTagLongArray getAsTagLongArray() {
        return (NBTTagLongArray)NBTTagLongArray.class.cast(this);
    }

    public static NBTTag newTagByType(TagType type, DataInputStream in) throws IOException {
        switch (type) {
            case BYTE: {
                return new NBTTagByte().readPayloadBytes(in);
            }
            case SHORT: {
                return new NBTTagShort().readPayloadBytes(in);
            }
            case INT: {
                return new NBTTagInt().readPayloadBytes(in);
            }
            case LONG: {
                return new NBTTagLong().readPayloadBytes(in);
            }
            case FLOAT: {
                return new NBTTagFloat().readPayloadBytes(in);
            }
            case DOUBLE: {
                return new NBTTagDouble().readPayloadBytes(in);
            }
            case BYTE_ARRAY: {
                return new NBTTagByteArray().readPayloadBytes(in);
            }
            case STRING: {
                return new NBTTagString().readPayloadBytes(in);
            }
            case LIST: {
                return new NBTTagList().readPayloadBytes(in);
            }
            case COMPOUND: {
                return new NBTTagCompound().readPayloadBytes(in);
            }
            case INT_ARRAY: {
                return new NBTTagIntArray().readPayloadBytes(in);
            }
            case LONG_ARRAY: {
                return new NBTTagLongArray().readPayloadBytes(in);
            }
        }
        return null;
    }
}

