/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.stream;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;
import mryurihi.tbnbt.tag.NBTTag;
import mryurihi.tbnbt.tag.NBTTagString;

public class NBTOutputStream
extends OutputStream {
    private DataOutputStream dos;

    public NBTOutputStream(OutputStream out, boolean compressed) throws IOException {
        if (compressed) {
            out = new GZIPOutputStream(out);
        }
        this.dos = new DataOutputStream(out);
    }

    public NBTOutputStream(OutputStream out) throws IOException {
        this(out, true);
    }

    public void writeTag(NBTTag tag, String name) throws IOException {
        this.dos.writeByte(tag.getTagType().getId());
        new NBTTagString("").writePayloadBytes(this.dos);
        tag.writePayloadBytes(this.dos);
    }

    public <T> void writeFromObject(TypeWrapper<T> type, Object obj, String name, AdapterRegistry registry) throws NBTParseException, IOException {
        NBTAdapter<T> adapter = registry.getAdapterForObject(type);
        this.dos.writeByte(adapter.getId().getId());
        registry.writeString(this.dos, name);
        adapter.toNBT(this.dos, obj, type, registry);
        this.dos.close();
    }

    public <T> void writeFromObject(TypeWrapper<T> type, Object obj, String name) throws NBTParseException, IOException {
        this.writeFromObject(type, obj, name, new AdapterRegistry.Builder().create());
    }

    public <T> void writeFromObject(TypeWrapper<T> type, Object obj) throws NBTParseException, IOException {
        this.writeFromObject(type, obj, "");
    }

    @Override
    public void close() throws IOException {
        this.dos.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.dos.write(b);
    }
}

