/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.stream;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;
import mryurihi.tbnbt.tag.NBTTag;
import mryurihi.tbnbt.tag.NBTTagString;

public class NBTInputStream
extends InputStream {
    private DataInputStream dis;

    public NBTInputStream(InputStream is, boolean compressed) throws IOException {
        if (compressed) {
            is = new GZIPInputStream(is);
        }
        this.dis = new DataInputStream(is);
    }

    public NBTInputStream(InputStream is) throws IOException {
        this(is, true);
    }

    public NBTTag readTag(boolean named) throws IOException {
        byte type = this.dis.readByte();
        if (named) {
            new NBTTagString("").readPayloadBytes(this.dis);
        }
        return NBTTag.newTagByType(TagType.getTypeById(type), this.dis);
    }

    public NBTTag readTag() throws IOException {
        return this.readTag(true);
    }

    public <T> T readToType(TypeWrapper<T> type, AdapterRegistry registry) throws IOException, NBTParseException {
        TagType id = TagType.getTypeById(this.dis.readByte());
        registry.fromString(this.dis);
        return (T)registry.getAdapterForObject(type).fromNBT(id, this.dis, type, registry);
    }

    public <T> T readToType(TypeWrapper<T> type) throws IOException, NBTParseException {
        return this.readToType(type, new AdapterRegistry.Builder().create());
    }

    @Override
    public void close() throws IOException {
        this.dis.close();
    }

    @Override
    public int read() throws IOException {
        return this.dis.read();
    }
}

