/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl.primitive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class IntegerAdapter
extends NBTAdapter<Integer> {
    @Override
    public Integer fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.INT)) {
            throw new NBTParseException(String.format("id %s does not match required id 3", id.getId()));
        }
        try {
            return payload.readInt();
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        try {
            out.writeInt((Integer)object);
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public TagType getId() {
        return TagType.INT;
    }
}

