/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl.primitive;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class FloatAdapter
extends NBTAdapter<Float> {
    @Override
    public Float fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.FLOAT)) {
            throw new NBTParseException(String.format("id %s does not match required id 5", id.getId()));
        }
        try {
            return Float.valueOf(payload.readFloat());
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        try {
            out.writeFloat(((Float)object).floatValue());
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public TagType getId() {
        return TagType.FLOAT;
    }
}

