/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class StringAdapter
extends NBTAdapter<String> {
    @Override
    public String fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.STRING)) {
            throw new NBTParseException(String.format("id %s does not match required id 8", id.getId()));
        }
        int length = registry.fromShort(payload).shortValue();
        byte[] out = new byte[length];
        for (int i = 0; i < length; ++i) {
            out[i] = registry.fromByte(payload);
        }
        return new String(out);
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        String string = (String)object;
        try {
            registry.getShortAdapter().toNBT(out, (short)string.length(), null, registry);
            for (byte b : string.getBytes()) {
                out.writeByte(b);
            }
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public TagType getId() {
        return TagType.STRING;
    }
}

