/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;
import mryurihi.tbnbt.annotations.SerializedName;

public class ObjectAdapter
extends NBTAdapter<Object> {
    @Override
    public Object fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        Object out;
        if (!id.equals((Object)TagType.COMPOUND)) {
            throw new NBTParseException(String.format("id %s does not match required id 10", id.getId()));
        }
        try {
            Constructor<?> constr = type.getClassType().getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            out = constr.newInstance(new Object[0]);
            byte nextTagType = payload.readByte();
            while (nextTagType != 0) {
                String tagName = registry.fromString(payload);
                Field objField = null;
                try {
                    objField = type.getClassType().getDeclaredField(tagName);
                }
                catch (NoSuchFieldException e) {
                    for (Field f : type.getClassType().getDeclaredFields()) {
                        if (!f.isAnnotationPresent(SerializedName.class) || !f.getAnnotation(SerializedName.class).value().equals(tagName)) continue;
                        objField = f;
                    }
                    if (objField == null) continue;
                }
                objField.setAccessible(true);
                NBTAdapter<?> adapter = registry.getAdapterForObject(TypeWrapper.of(objField.getGenericType()));
                objField.set(out, adapter.fromNBT(TagType.getTypeById(nextTagType), payload, TypeWrapper.of(objField.getGenericType()), registry));
                nextTagType = payload.readByte();
            }
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
        return out;
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        try {
            for (Field f : type.getClassType().getDeclaredFields()) {
                f.setAccessible(true);
                NBTAdapter<?> adapter = registry.getAdapterForObject(TypeWrapper.of(f.getGenericType()));
                out.writeByte(adapter.getId().getId());
                registry.writeString(out, f.isAnnotationPresent(SerializedName.class) ? f.getAnnotation(SerializedName.class).value() : f.getName());
                adapter.toNBT(out, f.get(object), TypeWrapper.of(f.getGenericType()), registry);
            }
            out.writeByte(0);
        }
        catch (Exception e) {
            throw new NBTParseException(e);
        }
    }

    @Override
    public TagType getId() {
        return TagType.COMPOUND;
    }
}

