/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTAdapterFactory;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class MapAdapterFactory
implements NBTAdapterFactory {
    @Override
    public <T> NBTAdapter<T> create(AdapterRegistry registry, TypeWrapper<T> type) {
        Class itemClass = (Class)((ParameterizedType)type.getType()).getActualTypeArguments()[1];
        return new Adapter(registry.getAdapterForObject(TypeWrapper.of(itemClass)), itemClass);
    }

    private static class Adapter<E>
    extends NBTAdapter<Map<String, E>> {
        private NBTAdapter<E> itemAdapter;
        private Class<E> itemClass;

        public Adapter(NBTAdapter<E> itemAdapter, Class<E> itemClass) {
            this.itemAdapter = itemAdapter;
            this.itemClass = itemClass;
        }

        @Override
        public Map<String, E> fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            try {
                Constructor<?> constr = type.getClassType().getDeclaredConstructor(new Class[0]);
                constr.setAccessible(true);
                Map out = (Map)constr.newInstance(new Object[0]);
                byte nextTagType = payload.readByte();
                do {
                    String tagName = registry.fromString(payload);
                    out.put(tagName, this.itemAdapter.fromNBT(TagType.getTypeById(nextTagType), payload, TypeWrapper.of(this.itemClass), registry));
                } while ((nextTagType = payload.readByte()) != 0);
            }
            catch (Exception e) {
                throw new NBTParseException(e);
            }
            return null;
        }

        @Override
        public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
            Map mapObj = (Map)object;
            for (Map.Entry entry : mapObj.entrySet()) {
                registry.writeByte(out, (byte)this.itemAdapter.getId().getId());
                registry.writeString(out, (String)entry.getKey());
                this.itemAdapter.toNBT(out, entry.getValue(), TypeWrapper.of(this.itemClass), registry);
            }
            registry.writeByte(out, (byte)0);
        }

        @Override
        public TagType getId() {
            return TagType.COMPOUND;
        }
    }
}

