/*
 * Decompiled with CFR 0.152.
 */
package mryurihi.tbnbt.adapter.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import mryurihi.tbnbt.TagType;
import mryurihi.tbnbt.adapter.AdapterRegistry;
import mryurihi.tbnbt.adapter.NBTAdapter;
import mryurihi.tbnbt.adapter.NBTParseException;
import mryurihi.tbnbt.adapter.TypeWrapper;

public class LongArrayAdapter
extends NBTAdapter<Long[]> {
    @Override
    public Long[] fromNBT(TagType id, DataInputStream payload, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        if (!id.equals((Object)TagType.INT_ARRAY)) {
            throw new NBTParseException(String.format("id %s does not match required id 11", id.getId()));
        }
        Long[] out = new Long[((Integer)registry.getIntAdapter().fromNBT(TagType.INT, payload, null, registry)).intValue()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Long)registry.getIntAdapter().fromNBT(TagType.INT, payload, null, registry);
        }
        return out;
    }

    @Override
    public void toNBT(DataOutputStream out, Object object, TypeWrapper<?> type, AdapterRegistry registry) throws NBTParseException {
        Long[] longArr;
        if (object instanceof long[]) {
            longArr = new Long[((long[])object).length];
            for (int i = 0; i < longArr.length; ++i) {
                longArr[i] = ((long[])object)[i];
            }
        } else {
            longArr = (Long[])object;
        }
        registry.writeInt(out, longArr.length);
        for (Long b : longArr) {
            registry.writeLong(out, b);
        }
    }

    @Override
    public TagType getId() {
        return TagType.INT_ARRAY;
    }
}

